/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acmpca.model.AcmPcaRequest;
import software.amazon.awssdk.services.acmpca.model.CertificateAuthorityStatus;
import software.amazon.awssdk.services.acmpca.model.RevocationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCertificateAuthorityRequest
extends AcmPcaRequest
implements ToCopyableBuilder<Builder, UpdateCertificateAuthorityRequest> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateCertificateAuthorityRequest.getter(UpdateCertificateAuthorityRequest::certificateAuthorityArn)).setter(UpdateCertificateAuthorityRequest.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<RevocationConfiguration> REVOCATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateCertificateAuthorityRequest.getter(UpdateCertificateAuthorityRequest::revocationConfiguration)).setter(UpdateCertificateAuthorityRequest.setter(Builder::revocationConfiguration)).constructor(RevocationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationConfiguration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateCertificateAuthorityRequest.getter(UpdateCertificateAuthorityRequest::statusAsString)).setter(UpdateCertificateAuthorityRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_ARN_FIELD, REVOCATION_CONFIGURATION_FIELD, STATUS_FIELD));
    private final String certificateAuthorityArn;
    private final RevocationConfiguration revocationConfiguration;
    private final String status;

    private UpdateCertificateAuthorityRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.revocationConfiguration = builder.revocationConfiguration;
        this.status = builder.status;
    }

    public String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public RevocationConfiguration revocationConfiguration() {
        return this.revocationConfiguration;
    }

    public CertificateAuthorityStatus status() {
        return CertificateAuthorityStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCertificateAuthorityRequest)) {
            return false;
        }
        UpdateCertificateAuthorityRequest other = (UpdateCertificateAuthorityRequest)((Object)obj);
        return Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && Objects.equals(this.revocationConfiguration(), other.revocationConfiguration()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateCertificateAuthorityRequest").add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("RevocationConfiguration", (Object)this.revocationConfiguration()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "RevocationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.revocationConfiguration()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCertificateAuthorityRequest, T> g) {
        return obj -> g.apply((UpdateCertificateAuthorityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmPcaRequest.BuilderImpl
    implements Builder {
        private String certificateAuthorityArn;
        private RevocationConfiguration revocationConfiguration;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCertificateAuthorityRequest model) {
            super(model);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.revocationConfiguration(model.revocationConfiguration);
            this.status(model.status);
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        public final RevocationConfiguration.Builder getRevocationConfiguration() {
            return this.revocationConfiguration != null ? this.revocationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder revocationConfiguration(RevocationConfiguration revocationConfiguration) {
            this.revocationConfiguration = revocationConfiguration;
            return this;
        }

        public final void setRevocationConfiguration(RevocationConfiguration.BuilderImpl revocationConfiguration) {
            this.revocationConfiguration = revocationConfiguration != null ? revocationConfiguration.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateAuthorityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCertificateAuthorityRequest build() {
            return new UpdateCertificateAuthorityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AcmPcaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCertificateAuthorityRequest> {
        public Builder certificateAuthorityArn(String var1);

        public Builder revocationConfiguration(RevocationConfiguration var1);

        default public Builder revocationConfiguration(Consumer<RevocationConfiguration.Builder> revocationConfiguration) {
            return this.revocationConfiguration((RevocationConfiguration)((RevocationConfiguration.Builder)RevocationConfiguration.builder().applyMutation(revocationConfiguration)).build());
        }

        public Builder status(String var1);

        public Builder status(CertificateAuthorityStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

