/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class IssueCertificateRequest extends AcmPcaRequest implements
        ToCopyableBuilder<IssueCertificateRequest.Builder, IssueCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IssueCertificateRequest::certificateAuthorityArn)).setter(setter(Builder::certificateAuthorityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build())
            .build();

    private static final SdkField<SdkBytes> CSR_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(IssueCertificateRequest::csr)).setter(setter(Builder::csr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Csr").build()).build();

    private static final SdkField<String> SIGNING_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IssueCertificateRequest::signingAlgorithmAsString)).setter(setter(Builder::signingAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithm").build()).build();

    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IssueCertificateRequest::templateArn)).setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()).build();

    private static final SdkField<Validity> VALIDITY_FIELD = SdkField.<Validity> builder(MarshallingType.SDK_POJO)
            .getter(getter(IssueCertificateRequest::validity)).setter(setter(Builder::validity)).constructor(Validity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validity").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IssueCertificateRequest::idempotencyToken)).setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_AUTHORITY_ARN_FIELD, CSR_FIELD, SIGNING_ALGORITHM_FIELD, TEMPLATE_ARN_FIELD, VALIDITY_FIELD,
            IDEMPOTENCY_TOKEN_FIELD));

    private final String certificateAuthorityArn;

    private final SdkBytes csr;

    private final String signingAlgorithm;

    private final String templateArn;

    private final Validity validity;

    private final String idempotencyToken;

    private IssueCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.csr = builder.csr;
        this.signingAlgorithm = builder.signingAlgorithm;
        this.templateArn = builder.templateArn;
        this.validity = builder.validity;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must be
     * of the form:
     * </p>
     * <p>
     * <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This
     *         must be of the form:</p>
     *         <p>
     *         <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
     */
    public String certificateAuthorityArn() {
        return certificateAuthorityArn;
    }

    /**
     * <p>
     * The certificate signing request (CSR) for the certificate you want to issue. You can use the following OpenSSL
     * command to create the CSR and a 2048 bit RSA private key.
     * </p>
     * <p>
     * <code>openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code>
     * </p>
     * <p>
     * If you have a configuration file, you can use the following OpenSSL command. The <code>usr_cert</code> block in
     * the configuration file contains your X509 version 3 extensions.
     * </p>
     * <p>
     * <code>openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days -365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code>
     * </p>
     * 
     * @return The certificate signing request (CSR) for the certificate you want to issue. You can use the following
     *         OpenSSL command to create the CSR and a 2048 bit RSA private key. </p>
     *         <p>
     *         <code>openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code>
     *         </p>
     *         <p>
     *         If you have a configuration file, you can use the following OpenSSL command. The <code>usr_cert</code>
     *         block in the configuration file contains your X509 version 3 extensions.
     *         </p>
     *         <p>
     *         <code>openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days -365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code>
     */
    public SdkBytes csr() {
        return csr;
    }

    /**
     * <p>
     * The name of the algorithm that will be used to sign the certificate to be issued.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signingAlgorithm}
     * will return {@link SigningAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #signingAlgorithmAsString}.
     * </p>
     * 
     * @return The name of the algorithm that will be used to sign the certificate to be issued.
     * @see SigningAlgorithm
     */
    public SigningAlgorithm signingAlgorithm() {
        return SigningAlgorithm.fromValue(signingAlgorithm);
    }

    /**
     * <p>
     * The name of the algorithm that will be used to sign the certificate to be issued.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signingAlgorithm}
     * will return {@link SigningAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #signingAlgorithmAsString}.
     * </p>
     * 
     * @return The name of the algorithm that will be used to sign the certificate to be issued.
     * @see SigningAlgorithm
     */
    public String signingAlgorithmAsString() {
        return signingAlgorithm;
    }

    /**
     * <p>
     * Specifies a custom configuration template to use when issuing a certificate. If this parameter is not provided,
     * ACM Private CA defaults to the <code>EndEntityCertificate/V1</code> template.
     * </p>
     * <p>
     * The following service-owned <code>TemplateArn</code> values are supported by ACM Private CA:
     * </p>
     * <ul>
     * <li>
     * <p>
     * arn:aws:acm-pca:::template/EndEntityCertificate/V1
     * </p>
     * </li>
     * <li>
     * <p>
     * arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen0/V1
     * </p>
     * </li>
     * <li>
     * <p>
     * arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen1/V1
     * </p>
     * </li>
     * <li>
     * <p>
     * arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen2/V1
     * </p>
     * </li>
     * <li>
     * <p>
     * arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen3/V1
     * </p>
     * </li>
     * <li>
     * <p>
     * arn:aws:acm-pca:::template/RootCACertificate/V1
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Using Templates</a>.
     * </p>
     * 
     * @return Specifies a custom configuration template to use when issuing a certificate. If this parameter is not
     *         provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code> template.</p>
     *         <p>
     *         The following service-owned <code>TemplateArn</code> values are supported by ACM Private CA:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         arn:aws:acm-pca:::template/EndEntityCertificate/V1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen0/V1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen1/V1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen2/V1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen3/V1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         arn:aws:acm-pca:::template/RootCACertificate/V1
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Using Templates</a>.
     */
    public String templateArn() {
        return templateArn;
    }

    /**
     * <p>
     * The type of the validity period.
     * </p>
     * 
     * @return The type of the validity period.
     */
    public Validity validity() {
        return validity;
    }

    /**
     * <p>
     * Custom string that can be used to distinguish between calls to the <b>IssueCertificate</b> action. Idempotency
     * tokens time out after one hour. Therefore, if you call <b>IssueCertificate</b> multiple times with the same
     * idempotency token within 5 minutes, ACM Private CA recognizes that you are requesting only one certificate and
     * will issue only one. If you change the idempotency token for each call, PCA recognizes that you are requesting
     * multiple certificates.
     * </p>
     * 
     * @return Custom string that can be used to distinguish between calls to the <b>IssueCertificate</b> action.
     *         Idempotency tokens time out after one hour. Therefore, if you call <b>IssueCertificate</b> multiple times
     *         with the same idempotency token within 5 minutes, ACM Private CA recognizes that you are requesting only
     *         one certificate and will issue only one. If you change the idempotency token for each call, PCA
     *         recognizes that you are requesting multiple certificates.
     */
    public String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(csr());
        hashCode = 31 * hashCode + Objects.hashCode(signingAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(validity());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IssueCertificateRequest)) {
            return false;
        }
        IssueCertificateRequest other = (IssueCertificateRequest) obj;
        return Objects.equals(certificateAuthorityArn(), other.certificateAuthorityArn()) && Objects.equals(csr(), other.csr())
                && Objects.equals(signingAlgorithmAsString(), other.signingAlgorithmAsString())
                && Objects.equals(templateArn(), other.templateArn()) && Objects.equals(validity(), other.validity())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IssueCertificateRequest").add("CertificateAuthorityArn", certificateAuthorityArn())
                .add("Csr", csr()).add("SigningAlgorithm", signingAlgorithmAsString()).add("TemplateArn", templateArn())
                .add("Validity", validity()).add("IdempotencyToken", idempotencyToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateAuthorityArn":
            return Optional.ofNullable(clazz.cast(certificateAuthorityArn()));
        case "Csr":
            return Optional.ofNullable(clazz.cast(csr()));
        case "SigningAlgorithm":
            return Optional.ofNullable(clazz.cast(signingAlgorithmAsString()));
        case "TemplateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "Validity":
            return Optional.ofNullable(clazz.cast(validity()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IssueCertificateRequest, T> g) {
        return obj -> g.apply((IssueCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmPcaRequest.Builder, SdkPojo, CopyableBuilder<Builder, IssueCertificateRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must
         * be of the form:
         * </p>
         * <p>
         * <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
         * </p>
         * 
         * @param certificateAuthorityArn
         *        The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>.
         *        This must be of the form:</p>
         *        <p>
         *        <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArn(String certificateAuthorityArn);

        /**
         * <p>
         * The certificate signing request (CSR) for the certificate you want to issue. You can use the following
         * OpenSSL command to create the CSR and a 2048 bit RSA private key.
         * </p>
         * <p>
         * <code>openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code>
         * </p>
         * <p>
         * If you have a configuration file, you can use the following OpenSSL command. The <code>usr_cert</code> block
         * in the configuration file contains your X509 version 3 extensions.
         * </p>
         * <p>
         * <code>openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days -365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code>
         * </p>
         * 
         * @param csr
         *        The certificate signing request (CSR) for the certificate you want to issue. You can use the following
         *        OpenSSL command to create the CSR and a 2048 bit RSA private key. </p>
         *        <p>
         *        <code>openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code>
         *        </p>
         *        <p>
         *        If you have a configuration file, you can use the following OpenSSL command. The <code>usr_cert</code>
         *        block in the configuration file contains your X509 version 3 extensions.
         *        </p>
         *        <p>
         *        <code>openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days -365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csr(SdkBytes csr);

        /**
         * <p>
         * The name of the algorithm that will be used to sign the certificate to be issued.
         * </p>
         * 
         * @param signingAlgorithm
         *        The name of the algorithm that will be used to sign the certificate to be issued.
         * @see SigningAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningAlgorithm
         */
        Builder signingAlgorithm(String signingAlgorithm);

        /**
         * <p>
         * The name of the algorithm that will be used to sign the certificate to be issued.
         * </p>
         * 
         * @param signingAlgorithm
         *        The name of the algorithm that will be used to sign the certificate to be issued.
         * @see SigningAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningAlgorithm
         */
        Builder signingAlgorithm(SigningAlgorithm signingAlgorithm);

        /**
         * <p>
         * Specifies a custom configuration template to use when issuing a certificate. If this parameter is not
         * provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code> template.
         * </p>
         * <p>
         * The following service-owned <code>TemplateArn</code> values are supported by ACM Private CA:
         * </p>
         * <ul>
         * <li>
         * <p>
         * arn:aws:acm-pca:::template/EndEntityCertificate/V1
         * </p>
         * </li>
         * <li>
         * <p>
         * arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen0/V1
         * </p>
         * </li>
         * <li>
         * <p>
         * arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen1/V1
         * </p>
         * </li>
         * <li>
         * <p>
         * arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen2/V1
         * </p>
         * </li>
         * <li>
         * <p>
         * arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen3/V1
         * </p>
         * </li>
         * <li>
         * <p>
         * arn:aws:acm-pca:::template/RootCACertificate/V1
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Using Templates</a>.
         * </p>
         * 
         * @param templateArn
         *        Specifies a custom configuration template to use when issuing a certificate. If this parameter is not
         *        provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code> template.</p>
         *        <p>
         *        The following service-owned <code>TemplateArn</code> values are supported by ACM Private CA:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        arn:aws:acm-pca:::template/EndEntityCertificate/V1
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen0/V1
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen1/V1
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen2/V1
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen3/V1
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        arn:aws:acm-pca:::template/RootCACertificate/V1
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Using Templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * <p>
         * The type of the validity period.
         * </p>
         * 
         * @param validity
         *        The type of the validity period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validity(Validity validity);

        /**
         * <p>
         * The type of the validity period.
         * </p>
         * This is a convenience that creates an instance of the {@link Validity.Builder} avoiding the need to create
         * one manually via {@link Validity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Validity.Builder#build()} is called immediately and its result is
         * passed to {@link #validity(Validity)}.
         * 
         * @param validity
         *        a consumer that will call methods on {@link Validity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validity(Validity)
         */
        default Builder validity(Consumer<Validity.Builder> validity) {
            return validity(Validity.builder().applyMutation(validity).build());
        }

        /**
         * <p>
         * Custom string that can be used to distinguish between calls to the <b>IssueCertificate</b> action.
         * Idempotency tokens time out after one hour. Therefore, if you call <b>IssueCertificate</b> multiple times
         * with the same idempotency token within 5 minutes, ACM Private CA recognizes that you are requesting only one
         * certificate and will issue only one. If you change the idempotency token for each call, PCA recognizes that
         * you are requesting multiple certificates.
         * </p>
         * 
         * @param idempotencyToken
         *        Custom string that can be used to distinguish between calls to the <b>IssueCertificate</b> action.
         *        Idempotency tokens time out after one hour. Therefore, if you call <b>IssueCertificate</b> multiple
         *        times with the same idempotency token within 5 minutes, ACM Private CA recognizes that you are
         *        requesting only one certificate and will issue only one. If you change the idempotency token for each
         *        call, PCA recognizes that you are requesting multiple certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AcmPcaRequest.BuilderImpl implements Builder {
        private String certificateAuthorityArn;

        private SdkBytes csr;

        private String signingAlgorithm;

        private String templateArn;

        private Validity validity;

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(IssueCertificateRequest model) {
            super(model);
            certificateAuthorityArn(model.certificateAuthorityArn);
            csr(model.csr);
            signingAlgorithm(model.signingAlgorithm);
            templateArn(model.templateArn);
            validity(model.validity);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getCertificateAuthorityArn() {
            return certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        public final ByteBuffer getCsr() {
            return csr == null ? null : csr.asByteBuffer();
        }

        @Override
        public final Builder csr(SdkBytes csr) {
            this.csr = StandardMemberCopier.copy(csr);
            return this;
        }

        public final void setCsr(ByteBuffer csr) {
            csr(csr == null ? null : SdkBytes.fromByteBuffer(csr));
        }

        public final String getSigningAlgorithm() {
            return signingAlgorithm;
        }

        @Override
        public final Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        @Override
        public final Builder signingAlgorithm(SigningAlgorithm signingAlgorithm) {
            this.signingAlgorithm(signingAlgorithm == null ? null : signingAlgorithm.toString());
            return this;
        }

        public final void setSigningAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        public final Validity.Builder getValidity() {
            return validity != null ? validity.toBuilder() : null;
        }

        @Override
        public final Builder validity(Validity validity) {
            this.validity = validity;
            return this;
        }

        public final void setValidity(Validity.BuilderImpl validity) {
            this.validity = validity != null ? validity.build() : null;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IssueCertificateRequest build() {
            return new IssueCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
