/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCertificateAuthorityAuditReportResponse extends AcmPcaResponse implements
        ToCopyableBuilder<CreateCertificateAuthorityAuditReportResponse.Builder, CreateCertificateAuthorityAuditReportResponse> {
    private static final SdkField<String> AUDIT_REPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCertificateAuthorityAuditReportResponse::auditReportId)).setter(setter(Builder::auditReportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditReportId").build()).build();

    private static final SdkField<String> S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCertificateAuthorityAuditReportResponse::s3Key)).setter(setter(Builder::s3Key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Key").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_REPORT_ID_FIELD,
            S3_KEY_FIELD));

    private final String auditReportId;

    private final String s3Key;

    private CreateCertificateAuthorityAuditReportResponse(BuilderImpl builder) {
        super(builder);
        this.auditReportId = builder.auditReportId;
        this.s3Key = builder.s3Key;
    }

    /**
     * <p>
     * An alphanumeric string that contains a report identifier.
     * </p>
     * 
     * @return An alphanumeric string that contains a report identifier.
     */
    public String auditReportId() {
        return auditReportId;
    }

    /**
     * <p>
     * The <b>key</b> that uniquely identifies the report file in your S3 bucket.
     * </p>
     * 
     * @return The <b>key</b> that uniquely identifies the report file in your S3 bucket.
     */
    public String s3Key() {
        return s3Key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(auditReportId());
        hashCode = 31 * hashCode + Objects.hashCode(s3Key());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCertificateAuthorityAuditReportResponse)) {
            return false;
        }
        CreateCertificateAuthorityAuditReportResponse other = (CreateCertificateAuthorityAuditReportResponse) obj;
        return Objects.equals(auditReportId(), other.auditReportId()) && Objects.equals(s3Key(), other.s3Key());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCertificateAuthorityAuditReportResponse").add("AuditReportId", auditReportId())
                .add("S3Key", s3Key()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuditReportId":
            return Optional.ofNullable(clazz.cast(auditReportId()));
        case "S3Key":
            return Optional.ofNullable(clazz.cast(s3Key()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCertificateAuthorityAuditReportResponse, T> g) {
        return obj -> g.apply((CreateCertificateAuthorityAuditReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmPcaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCertificateAuthorityAuditReportResponse> {
        /**
         * <p>
         * An alphanumeric string that contains a report identifier.
         * </p>
         * 
         * @param auditReportId
         *        An alphanumeric string that contains a report identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditReportId(String auditReportId);

        /**
         * <p>
         * The <b>key</b> that uniquely identifies the report file in your S3 bucket.
         * </p>
         * 
         * @param s3Key
         *        The <b>key</b> that uniquely identifies the report file in your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Key(String s3Key);
    }

    static final class BuilderImpl extends AcmPcaResponse.BuilderImpl implements Builder {
        private String auditReportId;

        private String s3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCertificateAuthorityAuditReportResponse model) {
            super(model);
            auditReportId(model.auditReportId);
            s3Key(model.s3Key);
        }

        public final String getAuditReportId() {
            return auditReportId;
        }

        @Override
        public final Builder auditReportId(String auditReportId) {
            this.auditReportId = auditReportId;
            return this;
        }

        public final void setAuditReportId(String auditReportId) {
            this.auditReportId = auditReportId;
        }

        public final String getS3Key() {
            return s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public CreateCertificateAuthorityAuditReportResponse build() {
            return new CreateCertificateAuthorityAuditReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
