/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RevocationReason {
    UNSPECIFIED("UNSPECIFIED"),
    KEY_COMPROMISE("KEY_COMPROMISE"),
    CERTIFICATE_AUTHORITY_COMPROMISE("CERTIFICATE_AUTHORITY_COMPROMISE"),
    AFFILIATION_CHANGED("AFFILIATION_CHANGED"),
    SUPERSEDED("SUPERSEDED"),
    CESSATION_OF_OPERATION("CESSATION_OF_OPERATION"),
    PRIVILEGE_WITHDRAWN("PRIVILEGE_WITHDRAWN"),
    A_A_COMPROMISE("A_A_COMPROMISE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RevocationReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RevocationReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RevocationReason.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RevocationReason> knownValues() {
        return Stream.of(RevocationReason.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

