/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acm.model.AcmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportCertificateRequest
extends AcmRequest
implements ToCopyableBuilder<Builder, ImportCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportCertificateRequest.getter(ImportCertificateRequest::certificateArn)).setter(ImportCertificateRequest.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()}).build();
    private static final SdkField<SdkBytes> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(ImportCertificateRequest.getter(ImportCertificateRequest::certificate)).setter(ImportCertificateRequest.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final SdkField<SdkBytes> PRIVATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(ImportCertificateRequest.getter(ImportCertificateRequest::privateKey)).setter(ImportCertificateRequest.setter(Builder::privateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKey").build()}).build();
    private static final SdkField<SdkBytes> CERTIFICATE_CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(ImportCertificateRequest.getter(ImportCertificateRequest::certificateChain)).setter(ImportCertificateRequest.setter(Builder::certificateChain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateChain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD, CERTIFICATE_FIELD, PRIVATE_KEY_FIELD, CERTIFICATE_CHAIN_FIELD));
    private final String certificateArn;
    private final SdkBytes certificate;
    private final SdkBytes privateKey;
    private final SdkBytes certificateChain;

    private ImportCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateArn = builder.certificateArn;
        this.certificate = builder.certificate;
        this.privateKey = builder.privateKey;
        this.certificateChain = builder.certificateChain;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public SdkBytes certificate() {
        return this.certificate;
    }

    public SdkBytes privateKey() {
        return this.privateKey;
    }

    public SdkBytes certificateChain() {
        return this.certificateChain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateChain());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportCertificateRequest)) {
            return false;
        }
        ImportCertificateRequest other = (ImportCertificateRequest)((Object)obj);
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.privateKey(), other.privateKey()) && Objects.equals(this.certificateChain(), other.certificateChain());
    }

    public String toString() {
        return ToString.builder((String)"ImportCertificateRequest").add("CertificateArn", (Object)this.certificateArn()).add("Certificate", (Object)this.certificate()).add("PrivateKey", (Object)(this.privateKey() == null ? null : "*** Sensitive Data Redacted ***")).add("CertificateChain", (Object)this.certificateChain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "PrivateKey": {
                return Optional.ofNullable(clazz.cast(this.privateKey()));
            }
            case "CertificateChain": {
                return Optional.ofNullable(clazz.cast(this.certificateChain()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportCertificateRequest, T> g) {
        return obj -> g.apply((ImportCertificateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmRequest.BuilderImpl
    implements Builder {
        private String certificateArn;
        private SdkBytes certificate;
        private SdkBytes privateKey;
        private SdkBytes certificateChain;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportCertificateRequest model) {
            super(model);
            this.certificateArn(model.certificateArn);
            this.certificate(model.certificate);
            this.privateKey(model.privateKey);
            this.certificateChain(model.certificateChain);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final ByteBuffer getCertificate() {
            return this.certificate == null ? null : this.certificate.asByteBuffer();
        }

        @Override
        public final Builder certificate(SdkBytes certificate) {
            this.certificate = StandardMemberCopier.copy((SdkBytes)certificate);
            return this;
        }

        public final void setCertificate(ByteBuffer certificate) {
            this.certificate(certificate == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)certificate));
        }

        public final ByteBuffer getPrivateKey() {
            return this.privateKey == null ? null : this.privateKey.asByteBuffer();
        }

        @Override
        public final Builder privateKey(SdkBytes privateKey) {
            this.privateKey = StandardMemberCopier.copy((SdkBytes)privateKey);
            return this;
        }

        public final void setPrivateKey(ByteBuffer privateKey) {
            this.privateKey(privateKey == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)privateKey));
        }

        public final ByteBuffer getCertificateChain() {
            return this.certificateChain == null ? null : this.certificateChain.asByteBuffer();
        }

        @Override
        public final Builder certificateChain(SdkBytes certificateChain) {
            this.certificateChain = StandardMemberCopier.copy((SdkBytes)certificateChain);
            return this;
        }

        public final void setCertificateChain(ByteBuffer certificateChain) {
            this.certificateChain(certificateChain == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)certificateChain));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportCertificateRequest build() {
            return new ImportCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AcmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportCertificateRequest> {
        public Builder certificateArn(String var1);

        public Builder certificate(SdkBytes var1);

        public Builder privateKey(SdkBytes var1);

        public Builder certificateChain(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

