/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum KeyUsageName {
    DIGITAL_SIGNATURE("DIGITAL_SIGNATURE"),
    NON_REPUDIATION("NON_REPUDIATION"),
    KEY_ENCIPHERMENT("KEY_ENCIPHERMENT"),
    DATA_ENCIPHERMENT("DATA_ENCIPHERMENT"),
    KEY_AGREEMENT("KEY_AGREEMENT"),
    CERTIFICATE_SIGNING("CERTIFICATE_SIGNING"),
    CRL_SIGNING("CRL_SIGNING"),
    ENCIPHER_ONLY("ENCIPHER_ONLY"),
    DECIPHER_ONLY("DECIPHER_ONLY"),
    ANY("ANY"),
    CUSTOM("CUSTOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private KeyUsageName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyUsageName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(KeyUsageName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyUsageName> knownValues() {
        return Stream.of(KeyUsageName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

