/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.acm.model.DomainValidation;
import software.amazon.awssdk.services.acm.model.DomainValidationListCopier;
import software.amazon.awssdk.services.acm.model.RenewalStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RenewalSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RenewalSummary> {
    private static final SdkField<String> RENEWAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RenewalSummary.getter(RenewalSummary::renewalStatusAsString)).setter(RenewalSummary.setter(Builder::renewalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalStatus").build()}).build();
    private static final SdkField<List<DomainValidation>> DOMAIN_VALIDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RenewalSummary.getter(RenewalSummary::domainValidationOptions)).setter(RenewalSummary.setter(Builder::domainValidationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainValidationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainValidation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENEWAL_STATUS_FIELD, DOMAIN_VALIDATION_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String renewalStatus;
    private final List<DomainValidation> domainValidationOptions;

    private RenewalSummary(BuilderImpl builder) {
        this.renewalStatus = builder.renewalStatus;
        this.domainValidationOptions = builder.domainValidationOptions;
    }

    public RenewalStatus renewalStatus() {
        return RenewalStatus.fromValue(this.renewalStatus);
    }

    public String renewalStatusAsString() {
        return this.renewalStatus;
    }

    public List<DomainValidation> domainValidationOptions() {
        return this.domainValidationOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainValidationOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewalSummary)) {
            return false;
        }
        RenewalSummary other = (RenewalSummary)obj;
        return Objects.equals(this.renewalStatusAsString(), other.renewalStatusAsString()) && Objects.equals(this.domainValidationOptions(), other.domainValidationOptions());
    }

    public String toString() {
        return ToString.builder((String)"RenewalSummary").add("RenewalStatus", (Object)this.renewalStatusAsString()).add("DomainValidationOptions", this.domainValidationOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RenewalStatus": {
                return Optional.ofNullable(clazz.cast(this.renewalStatusAsString()));
            }
            case "DomainValidationOptions": {
                return Optional.ofNullable(clazz.cast(this.domainValidationOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RenewalSummary, T> g) {
        return obj -> g.apply((RenewalSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String renewalStatus;
        private List<DomainValidation> domainValidationOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RenewalSummary model) {
            this.renewalStatus(model.renewalStatus);
            this.domainValidationOptions(model.domainValidationOptions);
        }

        public final String getRenewalStatusAsString() {
            return this.renewalStatus;
        }

        @Override
        public final Builder renewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
            return this;
        }

        @Override
        public final Builder renewalStatus(RenewalStatus renewalStatus) {
            this.renewalStatus(renewalStatus.toString());
            return this;
        }

        public final void setRenewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
        }

        public final Collection<DomainValidation.Builder> getDomainValidationOptions() {
            return this.domainValidationOptions != null ? (Collection)this.domainValidationOptions.stream().map(DomainValidation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainValidationOptions(Collection<DomainValidation> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationListCopier.copy(domainValidationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(DomainValidation ... domainValidationOptions) {
            this.domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(Consumer<DomainValidation.Builder> ... domainValidationOptions) {
            this.domainValidationOptions(Stream.of(domainValidationOptions).map(c -> (DomainValidation)((DomainValidation.Builder)DomainValidation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainValidationOptions(Collection<DomainValidation.BuilderImpl> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationListCopier.copyFromBuilder(domainValidationOptions);
        }

        public RenewalSummary build() {
            return new RenewalSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RenewalSummary> {
        public Builder renewalStatus(String var1);

        public Builder renewalStatus(RenewalStatus var1);

        public Builder domainValidationOptions(Collection<DomainValidation> var1);

        public Builder domainValidationOptions(DomainValidation ... var1);

        public Builder domainValidationOptions(Consumer<DomainValidation.Builder> ... var1);
    }
}

