/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.acm.model.ExtendedKeyUsageFilterListCopier;
import software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName;
import software.amazon.awssdk.services.acm.model.KeyAlgorithm;
import software.amazon.awssdk.services.acm.model.KeyAlgorithmListCopier;
import software.amazon.awssdk.services.acm.model.KeyUsageFilterListCopier;
import software.amazon.awssdk.services.acm.model.KeyUsageName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Filters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Filters> {
    private static final SdkField<List<String>> EXTENDED_KEY_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("extendedKeyUsage").getter(Filters.getter(Filters::extendedKeyUsageAsStrings)).setter(Filters.setter(Builder::extendedKeyUsageWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extendedKeyUsage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> KEY_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("keyUsage").getter(Filters.getter(Filters::keyUsageAsStrings)).setter(Filters.setter(Builder::keyUsageWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyUsage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> KEY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("keyTypes").getter(Filters.getter(Filters::keyTypesAsStrings)).setter(Filters.setter(Builder::keyTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENDED_KEY_USAGE_FIELD, KEY_USAGE_FIELD, KEY_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Filters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> extendedKeyUsage;
    private final List<String> keyUsage;
    private final List<String> keyTypes;

    private Filters(BuilderImpl builder) {
        this.extendedKeyUsage = builder.extendedKeyUsage;
        this.keyUsage = builder.keyUsage;
        this.keyTypes = builder.keyTypes;
    }

    public final List<ExtendedKeyUsageName> extendedKeyUsage() {
        return ExtendedKeyUsageFilterListCopier.copyStringToEnum(this.extendedKeyUsage);
    }

    public final boolean hasExtendedKeyUsage() {
        return this.extendedKeyUsage != null && !(this.extendedKeyUsage instanceof SdkAutoConstructList);
    }

    public final List<String> extendedKeyUsageAsStrings() {
        return this.extendedKeyUsage;
    }

    public final List<KeyUsageName> keyUsage() {
        return KeyUsageFilterListCopier.copyStringToEnum(this.keyUsage);
    }

    public final boolean hasKeyUsage() {
        return this.keyUsage != null && !(this.keyUsage instanceof SdkAutoConstructList);
    }

    public final List<String> keyUsageAsStrings() {
        return this.keyUsage;
    }

    public final List<KeyAlgorithm> keyTypes() {
        return KeyAlgorithmListCopier.copyStringToEnum(this.keyTypes);
    }

    public final boolean hasKeyTypes() {
        return this.keyTypes != null && !(this.keyTypes instanceof SdkAutoConstructList);
    }

    public final List<String> keyTypesAsStrings() {
        return this.keyTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExtendedKeyUsage() ? this.extendedKeyUsageAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyUsage() ? this.keyUsageAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyTypes() ? this.keyTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filters)) {
            return false;
        }
        Filters other = (Filters)obj;
        return this.hasExtendedKeyUsage() == other.hasExtendedKeyUsage() && Objects.equals(this.extendedKeyUsageAsStrings(), other.extendedKeyUsageAsStrings()) && this.hasKeyUsage() == other.hasKeyUsage() && Objects.equals(this.keyUsageAsStrings(), other.keyUsageAsStrings()) && this.hasKeyTypes() == other.hasKeyTypes() && Objects.equals(this.keyTypesAsStrings(), other.keyTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"Filters").add("ExtendedKeyUsage", this.hasExtendedKeyUsage() ? this.extendedKeyUsageAsStrings() : null).add("KeyUsage", this.hasKeyUsage() ? this.keyUsageAsStrings() : null).add("KeyTypes", this.hasKeyTypes() ? this.keyTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "extendedKeyUsage": {
                return Optional.ofNullable(clazz.cast(this.extendedKeyUsageAsStrings()));
            }
            case "keyUsage": {
                return Optional.ofNullable(clazz.cast(this.keyUsageAsStrings()));
            }
            case "keyTypes": {
                return Optional.ofNullable(clazz.cast(this.keyTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("extendedKeyUsage", EXTENDED_KEY_USAGE_FIELD);
        map.put("keyUsage", KEY_USAGE_FIELD);
        map.put("keyTypes", KEY_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Filters, T> g) {
        return obj -> g.apply((Filters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> extendedKeyUsage = DefaultSdkAutoConstructList.getInstance();
        private List<String> keyUsage = DefaultSdkAutoConstructList.getInstance();
        private List<String> keyTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filters model) {
            this.extendedKeyUsageWithStrings(model.extendedKeyUsage);
            this.keyUsageWithStrings(model.keyUsage);
            this.keyTypesWithStrings(model.keyTypes);
        }

        public final Collection<String> getExtendedKeyUsage() {
            if (this.extendedKeyUsage instanceof SdkAutoConstructList) {
                return null;
            }
            return this.extendedKeyUsage;
        }

        public final void setExtendedKeyUsage(Collection<String> extendedKeyUsage) {
            this.extendedKeyUsage = ExtendedKeyUsageFilterListCopier.copy(extendedKeyUsage);
        }

        @Override
        public final Builder extendedKeyUsageWithStrings(Collection<String> extendedKeyUsage) {
            this.extendedKeyUsage = ExtendedKeyUsageFilterListCopier.copy(extendedKeyUsage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsageWithStrings(String ... extendedKeyUsage) {
            this.extendedKeyUsageWithStrings(Arrays.asList(extendedKeyUsage));
            return this;
        }

        @Override
        public final Builder extendedKeyUsage(Collection<ExtendedKeyUsageName> extendedKeyUsage) {
            this.extendedKeyUsage = ExtendedKeyUsageFilterListCopier.copyEnumToString(extendedKeyUsage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsage(ExtendedKeyUsageName ... extendedKeyUsage) {
            this.extendedKeyUsage(Arrays.asList(extendedKeyUsage));
            return this;
        }

        public final Collection<String> getKeyUsage() {
            if (this.keyUsage instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keyUsage;
        }

        public final void setKeyUsage(Collection<String> keyUsage) {
            this.keyUsage = KeyUsageFilterListCopier.copy(keyUsage);
        }

        @Override
        public final Builder keyUsageWithStrings(Collection<String> keyUsage) {
            this.keyUsage = KeyUsageFilterListCopier.copy(keyUsage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyUsageWithStrings(String ... keyUsage) {
            this.keyUsageWithStrings(Arrays.asList(keyUsage));
            return this;
        }

        @Override
        public final Builder keyUsage(Collection<KeyUsageName> keyUsage) {
            this.keyUsage = KeyUsageFilterListCopier.copyEnumToString(keyUsage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyUsage(KeyUsageName ... keyUsage) {
            this.keyUsage(Arrays.asList(keyUsage));
            return this;
        }

        public final Collection<String> getKeyTypes() {
            if (this.keyTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keyTypes;
        }

        public final void setKeyTypes(Collection<String> keyTypes) {
            this.keyTypes = KeyAlgorithmListCopier.copy(keyTypes);
        }

        @Override
        public final Builder keyTypesWithStrings(Collection<String> keyTypes) {
            this.keyTypes = KeyAlgorithmListCopier.copy(keyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyTypesWithStrings(String ... keyTypes) {
            this.keyTypesWithStrings(Arrays.asList(keyTypes));
            return this;
        }

        @Override
        public final Builder keyTypes(Collection<KeyAlgorithm> keyTypes) {
            this.keyTypes = KeyAlgorithmListCopier.copyEnumToString(keyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyTypes(KeyAlgorithm ... keyTypes) {
            this.keyTypes(Arrays.asList(keyTypes));
            return this;
        }

        public Filters build() {
            return new Filters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Filters> {
        public Builder extendedKeyUsageWithStrings(Collection<String> var1);

        public Builder extendedKeyUsageWithStrings(String ... var1);

        public Builder extendedKeyUsage(Collection<ExtendedKeyUsageName> var1);

        public Builder extendedKeyUsage(ExtendedKeyUsageName ... var1);

        public Builder keyUsageWithStrings(Collection<String> var1);

        public Builder keyUsageWithStrings(String ... var1);

        public Builder keyUsage(Collection<KeyUsageName> var1);

        public Builder keyUsage(KeyUsageName ... var1);

        public Builder keyTypesWithStrings(Collection<String> var1);

        public Builder keyTypesWithStrings(String ... var1);

        public Builder keyTypes(Collection<KeyAlgorithm> var1);

        public Builder keyTypes(KeyAlgorithm ... var1);
    }
}

