/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.acm.model.DomainValidation;
import software.amazon.awssdk.services.acm.model.DomainValidationListCopier;
import software.amazon.awssdk.services.acm.model.FailureReason;
import software.amazon.awssdk.services.acm.model.RenewalStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RenewalSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RenewalSummary> {
    private static final SdkField<String> RENEWAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenewalStatus").getter(RenewalSummary.getter(RenewalSummary::renewalStatusAsString)).setter(RenewalSummary.setter(Builder::renewalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalStatus").build()}).build();
    private static final SdkField<List<DomainValidation>> DOMAIN_VALIDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainValidationOptions").getter(RenewalSummary.getter(RenewalSummary::domainValidationOptions)).setter(RenewalSummary.setter(Builder::domainValidationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainValidationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainValidation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RENEWAL_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenewalStatusReason").getter(RenewalSummary.getter(RenewalSummary::renewalStatusReasonAsString)).setter(RenewalSummary.setter(Builder::renewalStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalStatusReason").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(RenewalSummary.getter(RenewalSummary::updatedAt)).setter(RenewalSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENEWAL_STATUS_FIELD, DOMAIN_VALIDATION_OPTIONS_FIELD, RENEWAL_STATUS_REASON_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String renewalStatus;
    private final List<DomainValidation> domainValidationOptions;
    private final String renewalStatusReason;
    private final Instant updatedAt;

    private RenewalSummary(BuilderImpl builder) {
        this.renewalStatus = builder.renewalStatus;
        this.domainValidationOptions = builder.domainValidationOptions;
        this.renewalStatusReason = builder.renewalStatusReason;
        this.updatedAt = builder.updatedAt;
    }

    public final RenewalStatus renewalStatus() {
        return RenewalStatus.fromValue(this.renewalStatus);
    }

    public final String renewalStatusAsString() {
        return this.renewalStatus;
    }

    public final boolean hasDomainValidationOptions() {
        return this.domainValidationOptions != null && !(this.domainValidationOptions instanceof SdkAutoConstructList);
    }

    public final List<DomainValidation> domainValidationOptions() {
        return this.domainValidationOptions;
    }

    public final FailureReason renewalStatusReason() {
        return FailureReason.fromValue(this.renewalStatusReason);
    }

    public final String renewalStatusReasonAsString() {
        return this.renewalStatusReason;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainValidationOptions() ? this.domainValidationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalStatusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewalSummary)) {
            return false;
        }
        RenewalSummary other = (RenewalSummary)obj;
        return Objects.equals(this.renewalStatusAsString(), other.renewalStatusAsString()) && this.hasDomainValidationOptions() == other.hasDomainValidationOptions() && Objects.equals(this.domainValidationOptions(), other.domainValidationOptions()) && Objects.equals(this.renewalStatusReasonAsString(), other.renewalStatusReasonAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"RenewalSummary").add("RenewalStatus", (Object)this.renewalStatusAsString()).add("DomainValidationOptions", this.hasDomainValidationOptions() ? this.domainValidationOptions() : null).add("RenewalStatusReason", (Object)this.renewalStatusReasonAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RenewalStatus": {
                return Optional.ofNullable(clazz.cast(this.renewalStatusAsString()));
            }
            case "DomainValidationOptions": {
                return Optional.ofNullable(clazz.cast(this.domainValidationOptions()));
            }
            case "RenewalStatusReason": {
                return Optional.ofNullable(clazz.cast(this.renewalStatusReasonAsString()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RenewalSummary, T> g) {
        return obj -> g.apply((RenewalSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String renewalStatus;
        private List<DomainValidation> domainValidationOptions = DefaultSdkAutoConstructList.getInstance();
        private String renewalStatusReason;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewalSummary model) {
            this.renewalStatus(model.renewalStatus);
            this.domainValidationOptions(model.domainValidationOptions);
            this.renewalStatusReason(model.renewalStatusReason);
            this.updatedAt(model.updatedAt);
        }

        public final String getRenewalStatus() {
            return this.renewalStatus;
        }

        public final void setRenewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
        }

        @Override
        public final Builder renewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
            return this;
        }

        @Override
        public final Builder renewalStatus(RenewalStatus renewalStatus) {
            this.renewalStatus(renewalStatus == null ? null : renewalStatus.toString());
            return this;
        }

        public final List<DomainValidation.Builder> getDomainValidationOptions() {
            List<DomainValidation.Builder> result = DomainValidationListCopier.copyToBuilder(this.domainValidationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainValidationOptions(Collection<DomainValidation.BuilderImpl> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationListCopier.copyFromBuilder(domainValidationOptions);
        }

        @Override
        public final Builder domainValidationOptions(Collection<DomainValidation> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationListCopier.copy(domainValidationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(DomainValidation ... domainValidationOptions) {
            this.domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(Consumer<DomainValidation.Builder> ... domainValidationOptions) {
            this.domainValidationOptions(Stream.of(domainValidationOptions).map(c -> (DomainValidation)((DomainValidation.Builder)DomainValidation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRenewalStatusReason() {
            return this.renewalStatusReason;
        }

        public final void setRenewalStatusReason(String renewalStatusReason) {
            this.renewalStatusReason = renewalStatusReason;
        }

        @Override
        public final Builder renewalStatusReason(String renewalStatusReason) {
            this.renewalStatusReason = renewalStatusReason;
            return this;
        }

        @Override
        public final Builder renewalStatusReason(FailureReason renewalStatusReason) {
            this.renewalStatusReason(renewalStatusReason == null ? null : renewalStatusReason.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public RenewalSummary build() {
            return new RenewalSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RenewalSummary> {
        public Builder renewalStatus(String var1);

        public Builder renewalStatus(RenewalStatus var1);

        public Builder domainValidationOptions(Collection<DomainValidation> var1);

        public Builder domainValidationOptions(DomainValidation ... var1);

        public Builder domainValidationOptions(Consumer<DomainValidation.Builder> ... var1);

        public Builder renewalStatusReason(String var1);

        public Builder renewalStatusReason(FailureReason var1);

        public Builder updatedAt(Instant var1);
    }
}

