/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.acm.AcmClient;
import software.amazon.awssdk.services.acm.AcmClientBuilder;
import software.amazon.awssdk.services.acm.AcmServiceClientConfiguration;
import software.amazon.awssdk.services.acm.DefaultAcmBaseClientBuilder;
import software.amazon.awssdk.services.acm.DefaultAcmClient;
import software.amazon.awssdk.services.acm.endpoints.AcmEndpointProvider;

@SdkInternalApi
final class DefaultAcmClientBuilder
extends DefaultAcmBaseClientBuilder<AcmClientBuilder, AcmClient>
implements AcmClientBuilder {
    DefaultAcmClientBuilder() {
    }

    @Override
    public DefaultAcmClientBuilder endpointProvider(AcmEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AcmClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAcmClientBuilder.validateClientOptions(clientConfiguration);
        AcmServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAcmClient client = new DefaultAcmClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AcmServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AcmServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

