/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum KeyAlgorithm {
    RSA_1024("RSA_1024"),
    RSA_2048("RSA_2048"),
    RSA_3072("RSA_3072"),
    RSA_4096("RSA_4096"),
    EC_PRIME256_V1("EC_prime256v1"),
    EC_SECP384_R1("EC_secp384r1"),
    EC_SECP521_R1("EC_secp521r1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private KeyAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(KeyAlgorithm.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyAlgorithm> knownValues() {
        return Stream.of(KeyAlgorithm.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

