/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ExtendedKeyUsageName {
    TLS_WEB_SERVER_AUTHENTICATION("TLS_WEB_SERVER_AUTHENTICATION"),
    TLS_WEB_CLIENT_AUTHENTICATION("TLS_WEB_CLIENT_AUTHENTICATION"),
    CODE_SIGNING("CODE_SIGNING"),
    EMAIL_PROTECTION("EMAIL_PROTECTION"),
    TIME_STAMPING("TIME_STAMPING"),
    OCSP_SIGNING("OCSP_SIGNING"),
    IPSEC_END_SYSTEM("IPSEC_END_SYSTEM"),
    IPSEC_TUNNEL("IPSEC_TUNNEL"),
    IPSEC_USER("IPSEC_USER"),
    ANY("ANY"),
    NONE("NONE"),
    CUSTOM("CUSTOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ExtendedKeyUsageName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExtendedKeyUsageName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ExtendedKeyUsageName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExtendedKeyUsageName> knownValues() {
        return Stream.of(ExtendedKeyUsageName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

