/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides aggregate statistics about the findings for the specified unused access analyzer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnusedAccessFindingsStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<UnusedAccessFindingsStatistics.Builder, UnusedAccessFindingsStatistics> {
    private static final SdkField<List<UnusedAccessTypeStatistics>> UNUSED_ACCESS_TYPE_STATISTICS_FIELD = SdkField
            .<List<UnusedAccessTypeStatistics>> builder(MarshallingType.LIST)
            .memberName("unusedAccessTypeStatistics")
            .getter(getter(UnusedAccessFindingsStatistics::unusedAccessTypeStatistics))
            .setter(setter(Builder::unusedAccessTypeStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedAccessTypeStatistics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnusedAccessTypeStatistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnusedAccessTypeStatistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FindingAggregationAccountDetails>> TOP_ACCOUNTS_FIELD = SdkField
            .<List<FindingAggregationAccountDetails>> builder(MarshallingType.LIST)
            .memberName("topAccounts")
            .getter(getter(UnusedAccessFindingsStatistics::topAccounts))
            .setter(setter(Builder::topAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingAggregationAccountDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingAggregationAccountDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TOTAL_ACTIVE_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalActiveFindings").getter(getter(UnusedAccessFindingsStatistics::totalActiveFindings))
            .setter(setter(Builder::totalActiveFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalActiveFindings").build())
            .build();

    private static final SdkField<Integer> TOTAL_ARCHIVED_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalArchivedFindings").getter(getter(UnusedAccessFindingsStatistics::totalArchivedFindings))
            .setter(setter(Builder::totalArchivedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalArchivedFindings").build())
            .build();

    private static final SdkField<Integer> TOTAL_RESOLVED_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalResolvedFindings").getter(getter(UnusedAccessFindingsStatistics::totalResolvedFindings))
            .setter(setter(Builder::totalResolvedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResolvedFindings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            UNUSED_ACCESS_TYPE_STATISTICS_FIELD, TOP_ACCOUNTS_FIELD, TOTAL_ACTIVE_FINDINGS_FIELD, TOTAL_ARCHIVED_FINDINGS_FIELD,
            TOTAL_RESOLVED_FINDINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<UnusedAccessTypeStatistics> unusedAccessTypeStatistics;

    private final List<FindingAggregationAccountDetails> topAccounts;

    private final Integer totalActiveFindings;

    private final Integer totalArchivedFindings;

    private final Integer totalResolvedFindings;

    private UnusedAccessFindingsStatistics(BuilderImpl builder) {
        this.unusedAccessTypeStatistics = builder.unusedAccessTypeStatistics;
        this.topAccounts = builder.topAccounts;
        this.totalActiveFindings = builder.totalActiveFindings;
        this.totalArchivedFindings = builder.totalArchivedFindings;
        this.totalResolvedFindings = builder.totalResolvedFindings;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnusedAccessTypeStatistics property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUnusedAccessTypeStatistics() {
        return unusedAccessTypeStatistics != null && !(unusedAccessTypeStatistics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of details about the total number of findings for each type of unused access for the analyzer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnusedAccessTypeStatistics} method.
     * </p>
     * 
     * @return A list of details about the total number of findings for each type of unused access for the analyzer.
     */
    public final List<UnusedAccessTypeStatistics> unusedAccessTypeStatistics() {
        return unusedAccessTypeStatistics;
    }

    /**
     * For responses, this returns true if the service returned a value for the TopAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTopAccounts() {
        return topAccounts != null && !(topAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one to ten Amazon Web Services accounts that have the most active findings for the unused access
     * analyzer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopAccounts} method.
     * </p>
     * 
     * @return A list of one to ten Amazon Web Services accounts that have the most active findings for the unused
     *         access analyzer.
     */
    public final List<FindingAggregationAccountDetails> topAccounts() {
        return topAccounts;
    }

    /**
     * <p>
     * The total number of active findings for the unused access analyzer.
     * </p>
     * 
     * @return The total number of active findings for the unused access analyzer.
     */
    public final Integer totalActiveFindings() {
        return totalActiveFindings;
    }

    /**
     * <p>
     * The total number of archived findings for the unused access analyzer.
     * </p>
     * 
     * @return The total number of archived findings for the unused access analyzer.
     */
    public final Integer totalArchivedFindings() {
        return totalArchivedFindings;
    }

    /**
     * <p>
     * The total number of resolved findings for the unused access analyzer.
     * </p>
     * 
     * @return The total number of resolved findings for the unused access analyzer.
     */
    public final Integer totalResolvedFindings() {
        return totalResolvedFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasUnusedAccessTypeStatistics() ? unusedAccessTypeStatistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTopAccounts() ? topAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalActiveFindings());
        hashCode = 31 * hashCode + Objects.hashCode(totalArchivedFindings());
        hashCode = 31 * hashCode + Objects.hashCode(totalResolvedFindings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnusedAccessFindingsStatistics)) {
            return false;
        }
        UnusedAccessFindingsStatistics other = (UnusedAccessFindingsStatistics) obj;
        return hasUnusedAccessTypeStatistics() == other.hasUnusedAccessTypeStatistics()
                && Objects.equals(unusedAccessTypeStatistics(), other.unusedAccessTypeStatistics())
                && hasTopAccounts() == other.hasTopAccounts() && Objects.equals(topAccounts(), other.topAccounts())
                && Objects.equals(totalActiveFindings(), other.totalActiveFindings())
                && Objects.equals(totalArchivedFindings(), other.totalArchivedFindings())
                && Objects.equals(totalResolvedFindings(), other.totalResolvedFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnusedAccessFindingsStatistics")
                .add("UnusedAccessTypeStatistics", hasUnusedAccessTypeStatistics() ? unusedAccessTypeStatistics() : null)
                .add("TopAccounts", hasTopAccounts() ? topAccounts() : null).add("TotalActiveFindings", totalActiveFindings())
                .add("TotalArchivedFindings", totalArchivedFindings()).add("TotalResolvedFindings", totalResolvedFindings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unusedAccessTypeStatistics":
            return Optional.ofNullable(clazz.cast(unusedAccessTypeStatistics()));
        case "topAccounts":
            return Optional.ofNullable(clazz.cast(topAccounts()));
        case "totalActiveFindings":
            return Optional.ofNullable(clazz.cast(totalActiveFindings()));
        case "totalArchivedFindings":
            return Optional.ofNullable(clazz.cast(totalArchivedFindings()));
        case "totalResolvedFindings":
            return Optional.ofNullable(clazz.cast(totalResolvedFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("unusedAccessTypeStatistics", UNUSED_ACCESS_TYPE_STATISTICS_FIELD);
        map.put("topAccounts", TOP_ACCOUNTS_FIELD);
        map.put("totalActiveFindings", TOTAL_ACTIVE_FINDINGS_FIELD);
        map.put("totalArchivedFindings", TOTAL_ARCHIVED_FINDINGS_FIELD);
        map.put("totalResolvedFindings", TOTAL_RESOLVED_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnusedAccessFindingsStatistics, T> g) {
        return obj -> g.apply((UnusedAccessFindingsStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnusedAccessFindingsStatistics> {
        /**
         * <p>
         * A list of details about the total number of findings for each type of unused access for the analyzer.
         * </p>
         * 
         * @param unusedAccessTypeStatistics
         *        A list of details about the total number of findings for each type of unused access for the analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedAccessTypeStatistics(Collection<UnusedAccessTypeStatistics> unusedAccessTypeStatistics);

        /**
         * <p>
         * A list of details about the total number of findings for each type of unused access for the analyzer.
         * </p>
         * 
         * @param unusedAccessTypeStatistics
         *        A list of details about the total number of findings for each type of unused access for the analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedAccessTypeStatistics(UnusedAccessTypeStatistics... unusedAccessTypeStatistics);

        /**
         * <p>
         * A list of details about the total number of findings for each type of unused access for the analyzer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.accessanalyzer.model.UnusedAccessTypeStatistics.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.accessanalyzer.model.UnusedAccessTypeStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.accessanalyzer.model.UnusedAccessTypeStatistics.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #unusedAccessTypeStatistics(List<UnusedAccessTypeStatistics>)}.
         * 
         * @param unusedAccessTypeStatistics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.accessanalyzer.model.UnusedAccessTypeStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unusedAccessTypeStatistics(java.util.Collection<UnusedAccessTypeStatistics>)
         */
        Builder unusedAccessTypeStatistics(Consumer<UnusedAccessTypeStatistics.Builder>... unusedAccessTypeStatistics);

        /**
         * <p>
         * A list of one to ten Amazon Web Services accounts that have the most active findings for the unused access
         * analyzer.
         * </p>
         * 
         * @param topAccounts
         *        A list of one to ten Amazon Web Services accounts that have the most active findings for the unused
         *        access analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topAccounts(Collection<FindingAggregationAccountDetails> topAccounts);

        /**
         * <p>
         * A list of one to ten Amazon Web Services accounts that have the most active findings for the unused access
         * analyzer.
         * </p>
         * 
         * @param topAccounts
         *        A list of one to ten Amazon Web Services accounts that have the most active findings for the unused
         *        access analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topAccounts(FindingAggregationAccountDetails... topAccounts);

        /**
         * <p>
         * A list of one to ten Amazon Web Services accounts that have the most active findings for the unused access
         * analyzer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.accessanalyzer.model.FindingAggregationAccountDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.accessanalyzer.model.FindingAggregationAccountDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.accessanalyzer.model.FindingAggregationAccountDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #topAccounts(List<FindingAggregationAccountDetails>)}.
         * 
         * @param topAccounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.accessanalyzer.model.FindingAggregationAccountDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topAccounts(java.util.Collection<FindingAggregationAccountDetails>)
         */
        Builder topAccounts(Consumer<FindingAggregationAccountDetails.Builder>... topAccounts);

        /**
         * <p>
         * The total number of active findings for the unused access analyzer.
         * </p>
         * 
         * @param totalActiveFindings
         *        The total number of active findings for the unused access analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalActiveFindings(Integer totalActiveFindings);

        /**
         * <p>
         * The total number of archived findings for the unused access analyzer.
         * </p>
         * 
         * @param totalArchivedFindings
         *        The total number of archived findings for the unused access analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalArchivedFindings(Integer totalArchivedFindings);

        /**
         * <p>
         * The total number of resolved findings for the unused access analyzer.
         * </p>
         * 
         * @param totalResolvedFindings
         *        The total number of resolved findings for the unused access analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResolvedFindings(Integer totalResolvedFindings);
    }

    static final class BuilderImpl implements Builder {
        private List<UnusedAccessTypeStatistics> unusedAccessTypeStatistics = DefaultSdkAutoConstructList.getInstance();

        private List<FindingAggregationAccountDetails> topAccounts = DefaultSdkAutoConstructList.getInstance();

        private Integer totalActiveFindings;

        private Integer totalArchivedFindings;

        private Integer totalResolvedFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(UnusedAccessFindingsStatistics model) {
            unusedAccessTypeStatistics(model.unusedAccessTypeStatistics);
            topAccounts(model.topAccounts);
            totalActiveFindings(model.totalActiveFindings);
            totalArchivedFindings(model.totalArchivedFindings);
            totalResolvedFindings(model.totalResolvedFindings);
        }

        public final List<UnusedAccessTypeStatistics.Builder> getUnusedAccessTypeStatistics() {
            List<UnusedAccessTypeStatistics.Builder> result = UnusedAccessTypeStatisticsListCopier
                    .copyToBuilder(this.unusedAccessTypeStatistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnusedAccessTypeStatistics(
                Collection<UnusedAccessTypeStatistics.BuilderImpl> unusedAccessTypeStatistics) {
            this.unusedAccessTypeStatistics = UnusedAccessTypeStatisticsListCopier.copyFromBuilder(unusedAccessTypeStatistics);
        }

        @Override
        public final Builder unusedAccessTypeStatistics(Collection<UnusedAccessTypeStatistics> unusedAccessTypeStatistics) {
            this.unusedAccessTypeStatistics = UnusedAccessTypeStatisticsListCopier.copy(unusedAccessTypeStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unusedAccessTypeStatistics(UnusedAccessTypeStatistics... unusedAccessTypeStatistics) {
            unusedAccessTypeStatistics(Arrays.asList(unusedAccessTypeStatistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unusedAccessTypeStatistics(
                Consumer<UnusedAccessTypeStatistics.Builder>... unusedAccessTypeStatistics) {
            unusedAccessTypeStatistics(Stream.of(unusedAccessTypeStatistics)
                    .map(c -> UnusedAccessTypeStatistics.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FindingAggregationAccountDetails.Builder> getTopAccounts() {
            List<FindingAggregationAccountDetails.Builder> result = AccountAggregationsCopier.copyToBuilder(this.topAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopAccounts(Collection<FindingAggregationAccountDetails.BuilderImpl> topAccounts) {
            this.topAccounts = AccountAggregationsCopier.copyFromBuilder(topAccounts);
        }

        @Override
        public final Builder topAccounts(Collection<FindingAggregationAccountDetails> topAccounts) {
            this.topAccounts = AccountAggregationsCopier.copy(topAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topAccounts(FindingAggregationAccountDetails... topAccounts) {
            topAccounts(Arrays.asList(topAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topAccounts(Consumer<FindingAggregationAccountDetails.Builder>... topAccounts) {
            topAccounts(Stream.of(topAccounts).map(c -> FindingAggregationAccountDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalActiveFindings() {
            return totalActiveFindings;
        }

        public final void setTotalActiveFindings(Integer totalActiveFindings) {
            this.totalActiveFindings = totalActiveFindings;
        }

        @Override
        public final Builder totalActiveFindings(Integer totalActiveFindings) {
            this.totalActiveFindings = totalActiveFindings;
            return this;
        }

        public final Integer getTotalArchivedFindings() {
            return totalArchivedFindings;
        }

        public final void setTotalArchivedFindings(Integer totalArchivedFindings) {
            this.totalArchivedFindings = totalArchivedFindings;
        }

        @Override
        public final Builder totalArchivedFindings(Integer totalArchivedFindings) {
            this.totalArchivedFindings = totalArchivedFindings;
            return this;
        }

        public final Integer getTotalResolvedFindings() {
            return totalResolvedFindings;
        }

        public final void setTotalResolvedFindings(Integer totalResolvedFindings) {
            this.totalResolvedFindings = totalResolvedFindings;
        }

        @Override
        public final Builder totalResolvedFindings(Integer totalResolvedFindings) {
            this.totalResolvedFindings = totalResolvedFindings;
            return this;
        }

        @Override
        public UnusedAccessFindingsStatistics build() {
            return new UnusedAccessFindingsStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
