/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single element in a path through the JSON representation of a policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PathElement implements SdkPojo, Serializable, ToCopyableBuilder<PathElement.Builder, PathElement> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("index")
            .getter(getter(PathElement::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(PathElement::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<Substring> SUBSTRING_FIELD = SdkField.<Substring> builder(MarshallingType.SDK_POJO)
            .memberName("substring").getter(getter(PathElement::substring)).setter(setter(Builder::substring))
            .constructor(Substring::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("substring").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(PathElement::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, KEY_FIELD,
            SUBSTRING_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer index;

    private final String key;

    private final Substring substring;

    private final String value;

    private final Type type;

    private PathElement(BuilderImpl builder) {
        this.index = builder.index;
        this.key = builder.key;
        this.substring = builder.substring;
        this.value = builder.value;
        this.type = builder.type;
    }

    /**
     * <p>
     * Refers to an index in a JSON array.
     * </p>
     * 
     * @return Refers to an index in a JSON array.
     */
    public final Integer index() {
        return index;
    }

    /**
     * <p>
     * Refers to a key in a JSON object.
     * </p>
     * 
     * @return Refers to a key in a JSON object.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * Refers to a substring of a literal string in a JSON object.
     * </p>
     * 
     * @return Refers to a substring of a literal string in a JSON object.
     */
    public final Substring substring() {
        return substring;
    }

    /**
     * <p>
     * Refers to the value associated with a given key in a JSON object.
     * </p>
     * 
     * @return Refers to the value associated with a given key in a JSON object.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(index());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(substring());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathElement)) {
            return false;
        }
        PathElement other = (PathElement) obj;
        return Objects.equals(index(), other.index()) && Objects.equals(key(), other.key())
                && Objects.equals(substring(), other.substring()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PathElement").add("Index", index()).add("Key", key()).add("Substring", substring())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "index":
            return Optional.ofNullable(clazz.cast(index()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "substring":
            return Optional.ofNullable(clazz.cast(substring()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #index()} initialized to the given value.
     *
     * <p>
     * Refers to an index in a JSON array.
     * </p>
     * 
     * @param index
     *        Refers to an index in a JSON array.
     */
    public static PathElement fromIndex(Integer index) {
        return builder().index(index).build();
    }

    /**
     * Create an instance of this class with {@link #key()} initialized to the given value.
     *
     * <p>
     * Refers to a key in a JSON object.
     * </p>
     * 
     * @param key
     *        Refers to a key in a JSON object.
     */
    public static PathElement fromKey(String key) {
        return builder().key(key).build();
    }

    /**
     * Create an instance of this class with {@link #substring()} initialized to the given value.
     *
     * <p>
     * Refers to a substring of a literal string in a JSON object.
     * </p>
     * 
     * @param substring
     *        Refers to a substring of a literal string in a JSON object.
     */
    public static PathElement fromSubstring(Substring substring) {
        return builder().substring(substring).build();
    }

    /**
     * Create an instance of this class with {@link #substring()} initialized to the given value.
     *
     * <p>
     * Refers to a substring of a literal string in a JSON object.
     * </p>
     * 
     * @param substring
     *        Refers to a substring of a literal string in a JSON object.
     */
    public static PathElement fromSubstring(Consumer<Substring.Builder> substring) {
        Substring.Builder builder = Substring.builder();
        substring.accept(builder);
        return fromSubstring(builder.build());
    }

    /**
     * Create an instance of this class with {@link #value()} initialized to the given value.
     *
     * <p>
     * Refers to the value associated with a given key in a JSON object.
     * </p>
     * 
     * @param value
     *        Refers to the value associated with a given key in a JSON object.
     */
    public static PathElement fromValue(String value) {
        return builder().value(value).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("index", INDEX_FIELD);
        map.put("key", KEY_FIELD);
        map.put("substring", SUBSTRING_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PathElement, T> g) {
        return obj -> g.apply((PathElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PathElement> {
        /**
         * <p>
         * Refers to an index in a JSON array.
         * </p>
         * 
         * @param index
         *        Refers to an index in a JSON array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Integer index);

        /**
         * <p>
         * Refers to a key in a JSON object.
         * </p>
         * 
         * @param key
         *        Refers to a key in a JSON object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * Refers to a substring of a literal string in a JSON object.
         * </p>
         * 
         * @param substring
         *        Refers to a substring of a literal string in a JSON object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder substring(Substring substring);

        /**
         * <p>
         * Refers to a substring of a literal string in a JSON object.
         * </p>
         * This is a convenience method that creates an instance of the {@link Substring.Builder} avoiding the need to
         * create one manually via {@link Substring#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Substring.Builder#build()} is called immediately and its result
         * is passed to {@link #substring(Substring)}.
         * 
         * @param substring
         *        a consumer that will call methods on {@link Substring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #substring(Substring)
         */
        default Builder substring(Consumer<Substring.Builder> substring) {
            return substring(Substring.builder().applyMutation(substring).build());
        }

        /**
         * <p>
         * Refers to the value associated with a given key in a JSON object.
         * </p>
         * 
         * @param value
         *        Refers to the value associated with a given key in a JSON object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private Integer index;

        private String key;

        private Substring substring;

        private String value;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PathElement model) {
            index(model.index);
            key(model.key);
            substring(model.substring);
            value(model.value);
        }

        public final Integer getIndex() {
            return index;
        }

        public final void setIndex(Integer index) {
            Object oldValue = this.index;
            this.index = index;
            handleUnionValueChange(Type.INDEX, oldValue, this.index);
        }

        @Override
        public final Builder index(Integer index) {
            Object oldValue = this.index;
            this.index = index;
            handleUnionValueChange(Type.INDEX, oldValue, this.index);
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            Object oldValue = this.key;
            this.key = key;
            handleUnionValueChange(Type.KEY, oldValue, this.key);
        }

        @Override
        public final Builder key(String key) {
            Object oldValue = this.key;
            this.key = key;
            handleUnionValueChange(Type.KEY, oldValue, this.key);
            return this;
        }

        public final Substring.Builder getSubstring() {
            return substring != null ? substring.toBuilder() : null;
        }

        public final void setSubstring(Substring.BuilderImpl substring) {
            Object oldValue = this.substring;
            this.substring = substring != null ? substring.build() : null;
            handleUnionValueChange(Type.SUBSTRING, oldValue, this.substring);
        }

        @Override
        public final Builder substring(Substring substring) {
            Object oldValue = this.substring;
            this.substring = substring;
            handleUnionValueChange(Type.SUBSTRING, oldValue, this.substring);
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            Object oldValue = this.value;
            this.value = value;
            handleUnionValueChange(Type.VALUE, oldValue, this.value);
        }

        @Override
        public final Builder value(String value) {
            Object oldValue = this.value;
            this.value = value;
            handleUnionValueChange(Type.VALUE, oldValue, this.value);
            return this;
        }

        @Override
        public PathElement build() {
            return new PathElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PathElement#type()
     */
    public enum Type {
        INDEX,

        KEY,

        SUBSTRING,

        VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
