/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the total number of active, archived, and resolved findings for a resource type of an
 * internal access analyzer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InternalAccessResourceTypeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<InternalAccessResourceTypeDetails.Builder, InternalAccessResourceTypeDetails> {
    private static final SdkField<Integer> TOTAL_ACTIVE_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalActiveFindings").getter(getter(InternalAccessResourceTypeDetails::totalActiveFindings))
            .setter(setter(Builder::totalActiveFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalActiveFindings").build())
            .build();

    private static final SdkField<Integer> TOTAL_RESOLVED_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalResolvedFindings").getter(getter(InternalAccessResourceTypeDetails::totalResolvedFindings))
            .setter(setter(Builder::totalResolvedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResolvedFindings").build())
            .build();

    private static final SdkField<Integer> TOTAL_ARCHIVED_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalArchivedFindings").getter(getter(InternalAccessResourceTypeDetails::totalArchivedFindings))
            .setter(setter(Builder::totalArchivedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalArchivedFindings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_ACTIVE_FINDINGS_FIELD,
            TOTAL_RESOLVED_FINDINGS_FIELD, TOTAL_ARCHIVED_FINDINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer totalActiveFindings;

    private final Integer totalResolvedFindings;

    private final Integer totalArchivedFindings;

    private InternalAccessResourceTypeDetails(BuilderImpl builder) {
        this.totalActiveFindings = builder.totalActiveFindings;
        this.totalResolvedFindings = builder.totalResolvedFindings;
        this.totalArchivedFindings = builder.totalArchivedFindings;
    }

    /**
     * <p>
     * The total number of active findings for the resource type in the internal access analyzer.
     * </p>
     * 
     * @return The total number of active findings for the resource type in the internal access analyzer.
     */
    public final Integer totalActiveFindings() {
        return totalActiveFindings;
    }

    /**
     * <p>
     * The total number of resolved findings for the resource type in the internal access analyzer.
     * </p>
     * 
     * @return The total number of resolved findings for the resource type in the internal access analyzer.
     */
    public final Integer totalResolvedFindings() {
        return totalResolvedFindings;
    }

    /**
     * <p>
     * The total number of archived findings for the resource type in the internal access analyzer.
     * </p>
     * 
     * @return The total number of archived findings for the resource type in the internal access analyzer.
     */
    public final Integer totalArchivedFindings() {
        return totalArchivedFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalActiveFindings());
        hashCode = 31 * hashCode + Objects.hashCode(totalResolvedFindings());
        hashCode = 31 * hashCode + Objects.hashCode(totalArchivedFindings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternalAccessResourceTypeDetails)) {
            return false;
        }
        InternalAccessResourceTypeDetails other = (InternalAccessResourceTypeDetails) obj;
        return Objects.equals(totalActiveFindings(), other.totalActiveFindings())
                && Objects.equals(totalResolvedFindings(), other.totalResolvedFindings())
                && Objects.equals(totalArchivedFindings(), other.totalArchivedFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InternalAccessResourceTypeDetails").add("TotalActiveFindings", totalActiveFindings())
                .add("TotalResolvedFindings", totalResolvedFindings()).add("TotalArchivedFindings", totalArchivedFindings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalActiveFindings":
            return Optional.ofNullable(clazz.cast(totalActiveFindings()));
        case "totalResolvedFindings":
            return Optional.ofNullable(clazz.cast(totalResolvedFindings()));
        case "totalArchivedFindings":
            return Optional.ofNullable(clazz.cast(totalArchivedFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("totalActiveFindings", TOTAL_ACTIVE_FINDINGS_FIELD);
        map.put("totalResolvedFindings", TOTAL_RESOLVED_FINDINGS_FIELD);
        map.put("totalArchivedFindings", TOTAL_ARCHIVED_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InternalAccessResourceTypeDetails, T> g) {
        return obj -> g.apply((InternalAccessResourceTypeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InternalAccessResourceTypeDetails> {
        /**
         * <p>
         * The total number of active findings for the resource type in the internal access analyzer.
         * </p>
         * 
         * @param totalActiveFindings
         *        The total number of active findings for the resource type in the internal access analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalActiveFindings(Integer totalActiveFindings);

        /**
         * <p>
         * The total number of resolved findings for the resource type in the internal access analyzer.
         * </p>
         * 
         * @param totalResolvedFindings
         *        The total number of resolved findings for the resource type in the internal access analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResolvedFindings(Integer totalResolvedFindings);

        /**
         * <p>
         * The total number of archived findings for the resource type in the internal access analyzer.
         * </p>
         * 
         * @param totalArchivedFindings
         *        The total number of archived findings for the resource type in the internal access analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalArchivedFindings(Integer totalArchivedFindings);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalActiveFindings;

        private Integer totalResolvedFindings;

        private Integer totalArchivedFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(InternalAccessResourceTypeDetails model) {
            totalActiveFindings(model.totalActiveFindings);
            totalResolvedFindings(model.totalResolvedFindings);
            totalArchivedFindings(model.totalArchivedFindings);
        }

        public final Integer getTotalActiveFindings() {
            return totalActiveFindings;
        }

        public final void setTotalActiveFindings(Integer totalActiveFindings) {
            this.totalActiveFindings = totalActiveFindings;
        }

        @Override
        public final Builder totalActiveFindings(Integer totalActiveFindings) {
            this.totalActiveFindings = totalActiveFindings;
            return this;
        }

        public final Integer getTotalResolvedFindings() {
            return totalResolvedFindings;
        }

        public final void setTotalResolvedFindings(Integer totalResolvedFindings) {
            this.totalResolvedFindings = totalResolvedFindings;
        }

        @Override
        public final Builder totalResolvedFindings(Integer totalResolvedFindings) {
            this.totalResolvedFindings = totalResolvedFindings;
            return this;
        }

        public final Integer getTotalArchivedFindings() {
            return totalArchivedFindings;
        }

        public final void setTotalArchivedFindings(Integer totalArchivedFindings) {
            this.totalArchivedFindings = totalArchivedFindings;
        }

        @Override
        public final Builder totalArchivedFindings(Integer totalArchivedFindings) {
            this.totalArchivedFindings = totalArchivedFindings;
            return this;
        }

        @Override
        public InternalAccessResourceTypeDetails build() {
            return new InternalAccessResourceTypeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
