/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The proposed access control configuration for an IAM role. You can propose a configuration for a new IAM role or an
 * existing IAM role that you own by specifying the trust policy. If the configuration is for a new IAM role, you must
 * specify the trust policy. If the configuration is for an existing IAM role that you own and you do not propose the
 * trust policy, the access preview uses the existing trust policy for the role. The proposed trust policy cannot be an
 * empty string. For more information about role trust policy limits, see <a
 * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IamRoleConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IamRoleConfiguration.Builder, IamRoleConfiguration> {
    private static final SdkField<String> TRUST_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trustPolicy").getter(getter(IamRoleConfiguration::trustPolicy)).setter(setter(Builder::trustPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trustPolicy;

    private IamRoleConfiguration(BuilderImpl builder) {
        this.trustPolicy = builder.trustPolicy;
    }

    /**
     * <p>
     * The proposed trust policy for the IAM role.
     * </p>
     * 
     * @return The proposed trust policy for the IAM role.
     */
    public final String trustPolicy() {
        return trustPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trustPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamRoleConfiguration)) {
            return false;
        }
        IamRoleConfiguration other = (IamRoleConfiguration) obj;
        return Objects.equals(trustPolicy(), other.trustPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IamRoleConfiguration").add("TrustPolicy", trustPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trustPolicy":
            return Optional.ofNullable(clazz.cast(trustPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trustPolicy", TRUST_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IamRoleConfiguration, T> g) {
        return obj -> g.apply((IamRoleConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IamRoleConfiguration> {
        /**
         * <p>
         * The proposed trust policy for the IAM role.
         * </p>
         * 
         * @param trustPolicy
         *        The proposed trust policy for the IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustPolicy(String trustPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String trustPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(IamRoleConfiguration model) {
            trustPolicy(model.trustPolicy);
        }

        public final String getTrustPolicy() {
            return trustPolicy;
        }

        public final void setTrustPolicy(String trustPolicy) {
            this.trustPolicy = trustPolicy;
        }

        @Override
        public final Builder trustPolicy(String trustPolicy) {
            this.trustPolicy = trustPolicy;
            return this;
        }

        @Override
        public IamRoleConfiguration build() {
            return new IamRoleConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
