/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGeneratedPolicyResponse extends AccessAnalyzerResponse implements
        ToCopyableBuilder<GetGeneratedPolicyResponse.Builder, GetGeneratedPolicyResponse> {
    private static final SdkField<JobDetails> JOB_DETAILS_FIELD = SdkField.<JobDetails> builder(MarshallingType.SDK_POJO)
            .memberName("jobDetails").getter(getter(GetGeneratedPolicyResponse::jobDetails)).setter(setter(Builder::jobDetails))
            .constructor(JobDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDetails").build()).build();

    private static final SdkField<GeneratedPolicyResult> GENERATED_POLICY_RESULT_FIELD = SdkField
            .<GeneratedPolicyResult> builder(MarshallingType.SDK_POJO).memberName("generatedPolicyResult")
            .getter(getter(GetGeneratedPolicyResponse::generatedPolicyResult)).setter(setter(Builder::generatedPolicyResult))
            .constructor(GeneratedPolicyResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedPolicyResult").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DETAILS_FIELD,
            GENERATED_POLICY_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final JobDetails jobDetails;

    private final GeneratedPolicyResult generatedPolicyResult;

    private GetGeneratedPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.jobDetails = builder.jobDetails;
        this.generatedPolicyResult = builder.generatedPolicyResult;
    }

    /**
     * <p>
     * A <code>GeneratedPolicyDetails</code> object that contains details about the generated policy.
     * </p>
     * 
     * @return A <code>GeneratedPolicyDetails</code> object that contains details about the generated policy.
     */
    public final JobDetails jobDetails() {
        return jobDetails;
    }

    /**
     * <p>
     * A <code>GeneratedPolicyResult</code> object that contains the generated policies and associated details.
     * </p>
     * 
     * @return A <code>GeneratedPolicyResult</code> object that contains the generated policies and associated details.
     */
    public final GeneratedPolicyResult generatedPolicyResult() {
        return generatedPolicyResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobDetails());
        hashCode = 31 * hashCode + Objects.hashCode(generatedPolicyResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGeneratedPolicyResponse)) {
            return false;
        }
        GetGeneratedPolicyResponse other = (GetGeneratedPolicyResponse) obj;
        return Objects.equals(jobDetails(), other.jobDetails())
                && Objects.equals(generatedPolicyResult(), other.generatedPolicyResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGeneratedPolicyResponse").add("JobDetails", jobDetails())
                .add("GeneratedPolicyResult", generatedPolicyResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDetails":
            return Optional.ofNullable(clazz.cast(jobDetails()));
        case "generatedPolicyResult":
            return Optional.ofNullable(clazz.cast(generatedPolicyResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobDetails", JOB_DETAILS_FIELD);
        map.put("generatedPolicyResult", GENERATED_POLICY_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGeneratedPolicyResponse, T> g) {
        return obj -> g.apply((GetGeneratedPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetGeneratedPolicyResponse> {
        /**
         * <p>
         * A <code>GeneratedPolicyDetails</code> object that contains details about the generated policy.
         * </p>
         * 
         * @param jobDetails
         *        A <code>GeneratedPolicyDetails</code> object that contains details about the generated policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDetails(JobDetails jobDetails);

        /**
         * <p>
         * A <code>GeneratedPolicyDetails</code> object that contains details about the generated policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobDetails.Builder} avoiding the need to
         * create one manually via {@link JobDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobDetails.Builder#build()} is called immediately and its result
         * is passed to {@link #jobDetails(JobDetails)}.
         * 
         * @param jobDetails
         *        a consumer that will call methods on {@link JobDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobDetails(JobDetails)
         */
        default Builder jobDetails(Consumer<JobDetails.Builder> jobDetails) {
            return jobDetails(JobDetails.builder().applyMutation(jobDetails).build());
        }

        /**
         * <p>
         * A <code>GeneratedPolicyResult</code> object that contains the generated policies and associated details.
         * </p>
         * 
         * @param generatedPolicyResult
         *        A <code>GeneratedPolicyResult</code> object that contains the generated policies and associated
         *        details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedPolicyResult(GeneratedPolicyResult generatedPolicyResult);

        /**
         * <p>
         * A <code>GeneratedPolicyResult</code> object that contains the generated policies and associated details.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeneratedPolicyResult.Builder} avoiding
         * the need to create one manually via {@link GeneratedPolicyResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeneratedPolicyResult.Builder#build()} is called immediately and
         * its result is passed to {@link #generatedPolicyResult(GeneratedPolicyResult)}.
         * 
         * @param generatedPolicyResult
         *        a consumer that will call methods on {@link GeneratedPolicyResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generatedPolicyResult(GeneratedPolicyResult)
         */
        default Builder generatedPolicyResult(Consumer<GeneratedPolicyResult.Builder> generatedPolicyResult) {
            return generatedPolicyResult(GeneratedPolicyResult.builder().applyMutation(generatedPolicyResult).build());
        }
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private JobDetails jobDetails;

        private GeneratedPolicyResult generatedPolicyResult;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGeneratedPolicyResponse model) {
            super(model);
            jobDetails(model.jobDetails);
            generatedPolicyResult(model.generatedPolicyResult);
        }

        public final JobDetails.Builder getJobDetails() {
            return jobDetails != null ? jobDetails.toBuilder() : null;
        }

        public final void setJobDetails(JobDetails.BuilderImpl jobDetails) {
            this.jobDetails = jobDetails != null ? jobDetails.build() : null;
        }

        @Override
        public final Builder jobDetails(JobDetails jobDetails) {
            this.jobDetails = jobDetails;
            return this;
        }

        public final GeneratedPolicyResult.Builder getGeneratedPolicyResult() {
            return generatedPolicyResult != null ? generatedPolicyResult.toBuilder() : null;
        }

        public final void setGeneratedPolicyResult(GeneratedPolicyResult.BuilderImpl generatedPolicyResult) {
            this.generatedPolicyResult = generatedPolicyResult != null ? generatedPolicyResult.build() : null;
        }

        @Override
        public final Builder generatedPolicyResult(GeneratedPolicyResult generatedPolicyResult) {
            this.generatedPolicyResult = generatedPolicyResult;
            return this;
        }

        @Override
        public GetGeneratedPolicyResponse build() {
            return new GetGeneratedPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
