/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source of the finding. This indicates how the access that generated the finding is granted. It is populated for
 * Amazon S3 bucket findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingSource implements SdkPojo, Serializable, ToCopyableBuilder<FindingSource.Builder, FindingSource> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FindingSource::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<FindingSourceDetail> DETAIL_FIELD = SdkField
            .<FindingSourceDetail> builder(MarshallingType.SDK_POJO).memberName("detail").getter(getter(FindingSource::detail))
            .setter(setter(Builder::detail)).constructor(FindingSourceDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final FindingSourceDetail detail;

    private FindingSource(BuilderImpl builder) {
        this.type = builder.type;
        this.detail = builder.detail;
    }

    /**
     * <p>
     * Indicates the type of access that generated the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FindingSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates the type of access that generated the finding.
     * @see FindingSourceType
     */
    public final FindingSourceType type() {
        return FindingSourceType.fromValue(type);
    }

    /**
     * <p>
     * Indicates the type of access that generated the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FindingSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates the type of access that generated the finding.
     * @see FindingSourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Includes details about how the access that generated the finding is granted. This is populated for Amazon S3
     * bucket findings.
     * </p>
     * 
     * @return Includes details about how the access that generated the finding is granted. This is populated for Amazon
     *         S3 bucket findings.
     */
    public final FindingSourceDetail detail() {
        return detail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(detail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingSource)) {
            return false;
        }
        FindingSource other = (FindingSource) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(detail(), other.detail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingSource").add("Type", typeAsString()).add("Detail", detail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "detail":
            return Optional.ofNullable(clazz.cast(detail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("detail", DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingSource, T> g) {
        return obj -> g.apply((FindingSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingSource> {
        /**
         * <p>
         * Indicates the type of access that generated the finding.
         * </p>
         * 
         * @param type
         *        Indicates the type of access that generated the finding.
         * @see FindingSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingSourceType
         */
        Builder type(String type);

        /**
         * <p>
         * Indicates the type of access that generated the finding.
         * </p>
         * 
         * @param type
         *        Indicates the type of access that generated the finding.
         * @see FindingSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingSourceType
         */
        Builder type(FindingSourceType type);

        /**
         * <p>
         * Includes details about how the access that generated the finding is granted. This is populated for Amazon S3
         * bucket findings.
         * </p>
         * 
         * @param detail
         *        Includes details about how the access that generated the finding is granted. This is populated for
         *        Amazon S3 bucket findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detail(FindingSourceDetail detail);

        /**
         * <p>
         * Includes details about how the access that generated the finding is granted. This is populated for Amazon S3
         * bucket findings.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingSourceDetail.Builder} avoiding the
         * need to create one manually via {@link FindingSourceDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingSourceDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #detail(FindingSourceDetail)}.
         * 
         * @param detail
         *        a consumer that will call methods on {@link FindingSourceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detail(FindingSourceDetail)
         */
        default Builder detail(Consumer<FindingSourceDetail.Builder> detail) {
            return detail(FindingSourceDetail.builder().applyMutation(detail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private FindingSourceDetail detail;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingSource model) {
            type(model.type);
            detail(model.detail);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FindingSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final FindingSourceDetail.Builder getDetail() {
            return detail != null ? detail.toBuilder() : null;
        }

        public final void setDetail(FindingSourceDetail.BuilderImpl detail) {
            this.detail = detail != null ? detail.build() : null;
        }

        @Override
        public final Builder detail(FindingSourceDetail detail) {
            this.detail = detail;
            return this;
        }

        @Override
        public FindingSource build() {
            return new FindingSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
