/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.AccountAggregationsCopier;
import software.amazon.awssdk.services.accessanalyzer.model.FindingAggregationAccountDetails;
import software.amazon.awssdk.services.accessanalyzer.model.UnusedAccessTypeStatistics;
import software.amazon.awssdk.services.accessanalyzer.model.UnusedAccessTypeStatisticsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnusedAccessFindingsStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UnusedAccessFindingsStatistics> {
    private static final SdkField<List<UnusedAccessTypeStatistics>> UNUSED_ACCESS_TYPE_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("unusedAccessTypeStatistics").getter(UnusedAccessFindingsStatistics.getter(UnusedAccessFindingsStatistics::unusedAccessTypeStatistics)).setter(UnusedAccessFindingsStatistics.setter(Builder::unusedAccessTypeStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedAccessTypeStatistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnusedAccessTypeStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FindingAggregationAccountDetails>> TOP_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("topAccounts").getter(UnusedAccessFindingsStatistics.getter(UnusedAccessFindingsStatistics::topAccounts)).setter(UnusedAccessFindingsStatistics.setter(Builder::topAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingAggregationAccountDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_ACTIVE_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalActiveFindings").getter(UnusedAccessFindingsStatistics.getter(UnusedAccessFindingsStatistics::totalActiveFindings)).setter(UnusedAccessFindingsStatistics.setter(Builder::totalActiveFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalActiveFindings").build()}).build();
    private static final SdkField<Integer> TOTAL_ARCHIVED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalArchivedFindings").getter(UnusedAccessFindingsStatistics.getter(UnusedAccessFindingsStatistics::totalArchivedFindings)).setter(UnusedAccessFindingsStatistics.setter(Builder::totalArchivedFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalArchivedFindings").build()}).build();
    private static final SdkField<Integer> TOTAL_RESOLVED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalResolvedFindings").getter(UnusedAccessFindingsStatistics.getter(UnusedAccessFindingsStatistics::totalResolvedFindings)).setter(UnusedAccessFindingsStatistics.setter(Builder::totalResolvedFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResolvedFindings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNUSED_ACCESS_TYPE_STATISTICS_FIELD, TOP_ACCOUNTS_FIELD, TOTAL_ACTIVE_FINDINGS_FIELD, TOTAL_ARCHIVED_FINDINGS_FIELD, TOTAL_RESOLVED_FINDINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UnusedAccessFindingsStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<UnusedAccessTypeStatistics> unusedAccessTypeStatistics;
    private final List<FindingAggregationAccountDetails> topAccounts;
    private final Integer totalActiveFindings;
    private final Integer totalArchivedFindings;
    private final Integer totalResolvedFindings;

    private UnusedAccessFindingsStatistics(BuilderImpl builder) {
        this.unusedAccessTypeStatistics = builder.unusedAccessTypeStatistics;
        this.topAccounts = builder.topAccounts;
        this.totalActiveFindings = builder.totalActiveFindings;
        this.totalArchivedFindings = builder.totalArchivedFindings;
        this.totalResolvedFindings = builder.totalResolvedFindings;
    }

    public final boolean hasUnusedAccessTypeStatistics() {
        return this.unusedAccessTypeStatistics != null && !(this.unusedAccessTypeStatistics instanceof SdkAutoConstructList);
    }

    public final List<UnusedAccessTypeStatistics> unusedAccessTypeStatistics() {
        return this.unusedAccessTypeStatistics;
    }

    public final boolean hasTopAccounts() {
        return this.topAccounts != null && !(this.topAccounts instanceof SdkAutoConstructList);
    }

    public final List<FindingAggregationAccountDetails> topAccounts() {
        return this.topAccounts;
    }

    public final Integer totalActiveFindings() {
        return this.totalActiveFindings;
    }

    public final Integer totalArchivedFindings() {
        return this.totalArchivedFindings;
    }

    public final Integer totalResolvedFindings() {
        return this.totalResolvedFindings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnusedAccessTypeStatistics() ? this.unusedAccessTypeStatistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopAccounts() ? this.topAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalActiveFindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalArchivedFindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResolvedFindings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnusedAccessFindingsStatistics)) {
            return false;
        }
        UnusedAccessFindingsStatistics other = (UnusedAccessFindingsStatistics)obj;
        return this.hasUnusedAccessTypeStatistics() == other.hasUnusedAccessTypeStatistics() && Objects.equals(this.unusedAccessTypeStatistics(), other.unusedAccessTypeStatistics()) && this.hasTopAccounts() == other.hasTopAccounts() && Objects.equals(this.topAccounts(), other.topAccounts()) && Objects.equals(this.totalActiveFindings(), other.totalActiveFindings()) && Objects.equals(this.totalArchivedFindings(), other.totalArchivedFindings()) && Objects.equals(this.totalResolvedFindings(), other.totalResolvedFindings());
    }

    public final String toString() {
        return ToString.builder((String)"UnusedAccessFindingsStatistics").add("UnusedAccessTypeStatistics", this.hasUnusedAccessTypeStatistics() ? this.unusedAccessTypeStatistics() : null).add("TopAccounts", this.hasTopAccounts() ? this.topAccounts() : null).add("TotalActiveFindings", (Object)this.totalActiveFindings()).add("TotalArchivedFindings", (Object)this.totalArchivedFindings()).add("TotalResolvedFindings", (Object)this.totalResolvedFindings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "unusedAccessTypeStatistics": {
                return Optional.ofNullable(clazz.cast(this.unusedAccessTypeStatistics()));
            }
            case "topAccounts": {
                return Optional.ofNullable(clazz.cast(this.topAccounts()));
            }
            case "totalActiveFindings": {
                return Optional.ofNullable(clazz.cast(this.totalActiveFindings()));
            }
            case "totalArchivedFindings": {
                return Optional.ofNullable(clazz.cast(this.totalArchivedFindings()));
            }
            case "totalResolvedFindings": {
                return Optional.ofNullable(clazz.cast(this.totalResolvedFindings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("unusedAccessTypeStatistics", UNUSED_ACCESS_TYPE_STATISTICS_FIELD);
        map.put("topAccounts", TOP_ACCOUNTS_FIELD);
        map.put("totalActiveFindings", TOTAL_ACTIVE_FINDINGS_FIELD);
        map.put("totalArchivedFindings", TOTAL_ARCHIVED_FINDINGS_FIELD);
        map.put("totalResolvedFindings", TOTAL_RESOLVED_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnusedAccessFindingsStatistics, T> g) {
        return obj -> g.apply((UnusedAccessFindingsStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<UnusedAccessTypeStatistics> unusedAccessTypeStatistics = DefaultSdkAutoConstructList.getInstance();
        private List<FindingAggregationAccountDetails> topAccounts = DefaultSdkAutoConstructList.getInstance();
        private Integer totalActiveFindings;
        private Integer totalArchivedFindings;
        private Integer totalResolvedFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(UnusedAccessFindingsStatistics model) {
            this.unusedAccessTypeStatistics(model.unusedAccessTypeStatistics);
            this.topAccounts(model.topAccounts);
            this.totalActiveFindings(model.totalActiveFindings);
            this.totalArchivedFindings(model.totalArchivedFindings);
            this.totalResolvedFindings(model.totalResolvedFindings);
        }

        public final List<UnusedAccessTypeStatistics.Builder> getUnusedAccessTypeStatistics() {
            List<UnusedAccessTypeStatistics.Builder> result = UnusedAccessTypeStatisticsListCopier.copyToBuilder(this.unusedAccessTypeStatistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnusedAccessTypeStatistics(Collection<UnusedAccessTypeStatistics.BuilderImpl> unusedAccessTypeStatistics) {
            this.unusedAccessTypeStatistics = UnusedAccessTypeStatisticsListCopier.copyFromBuilder(unusedAccessTypeStatistics);
        }

        @Override
        public final Builder unusedAccessTypeStatistics(Collection<UnusedAccessTypeStatistics> unusedAccessTypeStatistics) {
            this.unusedAccessTypeStatistics = UnusedAccessTypeStatisticsListCopier.copy(unusedAccessTypeStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unusedAccessTypeStatistics(UnusedAccessTypeStatistics ... unusedAccessTypeStatistics) {
            this.unusedAccessTypeStatistics(Arrays.asList(unusedAccessTypeStatistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unusedAccessTypeStatistics(Consumer<UnusedAccessTypeStatistics.Builder> ... unusedAccessTypeStatistics) {
            this.unusedAccessTypeStatistics(Stream.of(unusedAccessTypeStatistics).map(c -> (UnusedAccessTypeStatistics)((UnusedAccessTypeStatistics.Builder)UnusedAccessTypeStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FindingAggregationAccountDetails.Builder> getTopAccounts() {
            List<FindingAggregationAccountDetails.Builder> result = AccountAggregationsCopier.copyToBuilder(this.topAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopAccounts(Collection<FindingAggregationAccountDetails.BuilderImpl> topAccounts) {
            this.topAccounts = AccountAggregationsCopier.copyFromBuilder(topAccounts);
        }

        @Override
        public final Builder topAccounts(Collection<FindingAggregationAccountDetails> topAccounts) {
            this.topAccounts = AccountAggregationsCopier.copy(topAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topAccounts(FindingAggregationAccountDetails ... topAccounts) {
            this.topAccounts(Arrays.asList(topAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topAccounts(Consumer<FindingAggregationAccountDetails.Builder> ... topAccounts) {
            this.topAccounts(Stream.of(topAccounts).map(c -> (FindingAggregationAccountDetails)((FindingAggregationAccountDetails.Builder)FindingAggregationAccountDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalActiveFindings() {
            return this.totalActiveFindings;
        }

        public final void setTotalActiveFindings(Integer totalActiveFindings) {
            this.totalActiveFindings = totalActiveFindings;
        }

        @Override
        public final Builder totalActiveFindings(Integer totalActiveFindings) {
            this.totalActiveFindings = totalActiveFindings;
            return this;
        }

        public final Integer getTotalArchivedFindings() {
            return this.totalArchivedFindings;
        }

        public final void setTotalArchivedFindings(Integer totalArchivedFindings) {
            this.totalArchivedFindings = totalArchivedFindings;
        }

        @Override
        public final Builder totalArchivedFindings(Integer totalArchivedFindings) {
            this.totalArchivedFindings = totalArchivedFindings;
            return this;
        }

        public final Integer getTotalResolvedFindings() {
            return this.totalResolvedFindings;
        }

        public final void setTotalResolvedFindings(Integer totalResolvedFindings) {
            this.totalResolvedFindings = totalResolvedFindings;
        }

        @Override
        public final Builder totalResolvedFindings(Integer totalResolvedFindings) {
            this.totalResolvedFindings = totalResolvedFindings;
            return this;
        }

        public UnusedAccessFindingsStatistics build() {
            return new UnusedAccessFindingsStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UnusedAccessFindingsStatistics> {
        public Builder unusedAccessTypeStatistics(Collection<UnusedAccessTypeStatistics> var1);

        public Builder unusedAccessTypeStatistics(UnusedAccessTypeStatistics ... var1);

        public Builder unusedAccessTypeStatistics(Consumer<UnusedAccessTypeStatistics.Builder> ... var1);

        public Builder topAccounts(Collection<FindingAggregationAccountDetails> var1);

        public Builder topAccounts(FindingAggregationAccountDetails ... var1);

        public Builder topAccounts(Consumer<FindingAggregationAccountDetails.Builder> ... var1);

        public Builder totalActiveFindings(Integer var1);

        public Builder totalArchivedFindings(Integer var1);

        public Builder totalResolvedFindings(Integer var1);
    }
}

