/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.UnusedAccessConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyzerConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalyzerConfiguration> {
    private static final SdkField<UnusedAccessConfiguration> UNUSED_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("unusedAccess").getter(AnalyzerConfiguration.getter(AnalyzerConfiguration::unusedAccess)).setter(AnalyzerConfiguration.setter(Builder::unusedAccess)).constructor(UnusedAccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedAccess").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNUSED_ACCESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalyzerConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final UnusedAccessConfiguration unusedAccess;
    private final Type type;

    private AnalyzerConfiguration(BuilderImpl builder) {
        this.unusedAccess = builder.unusedAccess;
        this.type = builder.type;
    }

    public final UnusedAccessConfiguration unusedAccess() {
        return this.unusedAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.unusedAccess());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzerConfiguration)) {
            return false;
        }
        AnalyzerConfiguration other = (AnalyzerConfiguration)obj;
        return Objects.equals(this.unusedAccess(), other.unusedAccess());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyzerConfiguration").add("UnusedAccess", (Object)this.unusedAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "unusedAccess": {
                return Optional.ofNullable(clazz.cast(this.unusedAccess()));
            }
        }
        return Optional.empty();
    }

    public static AnalyzerConfiguration fromUnusedAccess(UnusedAccessConfiguration unusedAccess) {
        return (AnalyzerConfiguration)AnalyzerConfiguration.builder().unusedAccess(unusedAccess).build();
    }

    public static AnalyzerConfiguration fromUnusedAccess(Consumer<UnusedAccessConfiguration.Builder> unusedAccess) {
        UnusedAccessConfiguration.Builder builder = UnusedAccessConfiguration.builder();
        unusedAccess.accept(builder);
        return AnalyzerConfiguration.fromUnusedAccess((UnusedAccessConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<UnusedAccessConfiguration>> map = new HashMap<String, SdkField<UnusedAccessConfiguration>>();
        map.put("unusedAccess", UNUSED_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyzerConfiguration, T> g) {
        return obj -> g.apply((AnalyzerConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        UNUSED_ACCESS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private UnusedAccessConfiguration unusedAccess;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzerConfiguration model) {
            this.unusedAccess(model.unusedAccess);
        }

        public final UnusedAccessConfiguration.Builder getUnusedAccess() {
            return this.unusedAccess != null ? this.unusedAccess.toBuilder() : null;
        }

        public final void setUnusedAccess(UnusedAccessConfiguration.BuilderImpl unusedAccess) {
            UnusedAccessConfiguration oldValue = this.unusedAccess;
            this.unusedAccess = unusedAccess != null ? unusedAccess.build() : null;
            this.handleUnionValueChange(Type.UNUSED_ACCESS, oldValue, this.unusedAccess);
        }

        @Override
        public final Builder unusedAccess(UnusedAccessConfiguration unusedAccess) {
            UnusedAccessConfiguration oldValue = this.unusedAccess;
            this.unusedAccess = unusedAccess;
            this.handleUnionValueChange(Type.UNUSED_ACCESS, oldValue, this.unusedAccess);
            return this;
        }

        public AnalyzerConfiguration build() {
            return new AnalyzerConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalyzerConfiguration> {
        public Builder unusedAccess(UnusedAccessConfiguration var1);

        default public Builder unusedAccess(Consumer<UnusedAccessConfiguration.Builder> unusedAccess) {
            return this.unusedAccess((UnusedAccessConfiguration)((UnusedAccessConfiguration.Builder)UnusedAccessConfiguration.builder().applyMutation(unusedAccess)).build());
        }
    }
}

