/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.ExternalAccessFindingsStatistics;
import software.amazon.awssdk.services.accessanalyzer.model.UnusedAccessFindingsStatistics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingsStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingsStatistics> {
    private static final SdkField<ExternalAccessFindingsStatistics> EXTERNAL_ACCESS_FINDINGS_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("externalAccessFindingsStatistics").getter(FindingsStatistics.getter(FindingsStatistics::externalAccessFindingsStatistics)).setter(FindingsStatistics.setter(Builder::externalAccessFindingsStatistics)).constructor(ExternalAccessFindingsStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalAccessFindingsStatistics").build()}).build();
    private static final SdkField<UnusedAccessFindingsStatistics> UNUSED_ACCESS_FINDINGS_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("unusedAccessFindingsStatistics").getter(FindingsStatistics.getter(FindingsStatistics::unusedAccessFindingsStatistics)).setter(FindingsStatistics.setter(Builder::unusedAccessFindingsStatistics)).constructor(UnusedAccessFindingsStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedAccessFindingsStatistics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_ACCESS_FINDINGS_STATISTICS_FIELD, UNUSED_ACCESS_FINDINGS_STATISTICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FindingsStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ExternalAccessFindingsStatistics externalAccessFindingsStatistics;
    private final UnusedAccessFindingsStatistics unusedAccessFindingsStatistics;
    private final Type type;

    private FindingsStatistics(BuilderImpl builder) {
        this.externalAccessFindingsStatistics = builder.externalAccessFindingsStatistics;
        this.unusedAccessFindingsStatistics = builder.unusedAccessFindingsStatistics;
        this.type = builder.type;
    }

    public final ExternalAccessFindingsStatistics externalAccessFindingsStatistics() {
        return this.externalAccessFindingsStatistics;
    }

    public final UnusedAccessFindingsStatistics unusedAccessFindingsStatistics() {
        return this.unusedAccessFindingsStatistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.externalAccessFindingsStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.unusedAccessFindingsStatistics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingsStatistics)) {
            return false;
        }
        FindingsStatistics other = (FindingsStatistics)obj;
        return Objects.equals(this.externalAccessFindingsStatistics(), other.externalAccessFindingsStatistics()) && Objects.equals(this.unusedAccessFindingsStatistics(), other.unusedAccessFindingsStatistics());
    }

    public final String toString() {
        return ToString.builder((String)"FindingsStatistics").add("ExternalAccessFindingsStatistics", (Object)this.externalAccessFindingsStatistics()).add("UnusedAccessFindingsStatistics", (Object)this.unusedAccessFindingsStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "externalAccessFindingsStatistics": {
                return Optional.ofNullable(clazz.cast(this.externalAccessFindingsStatistics()));
            }
            case "unusedAccessFindingsStatistics": {
                return Optional.ofNullable(clazz.cast(this.unusedAccessFindingsStatistics()));
            }
        }
        return Optional.empty();
    }

    public static FindingsStatistics fromExternalAccessFindingsStatistics(ExternalAccessFindingsStatistics externalAccessFindingsStatistics) {
        return (FindingsStatistics)FindingsStatistics.builder().externalAccessFindingsStatistics(externalAccessFindingsStatistics).build();
    }

    public static FindingsStatistics fromExternalAccessFindingsStatistics(Consumer<ExternalAccessFindingsStatistics.Builder> externalAccessFindingsStatistics) {
        ExternalAccessFindingsStatistics.Builder builder = ExternalAccessFindingsStatistics.builder();
        externalAccessFindingsStatistics.accept(builder);
        return FindingsStatistics.fromExternalAccessFindingsStatistics((ExternalAccessFindingsStatistics)builder.build());
    }

    public static FindingsStatistics fromUnusedAccessFindingsStatistics(UnusedAccessFindingsStatistics unusedAccessFindingsStatistics) {
        return (FindingsStatistics)FindingsStatistics.builder().unusedAccessFindingsStatistics(unusedAccessFindingsStatistics).build();
    }

    public static FindingsStatistics fromUnusedAccessFindingsStatistics(Consumer<UnusedAccessFindingsStatistics.Builder> unusedAccessFindingsStatistics) {
        UnusedAccessFindingsStatistics.Builder builder = UnusedAccessFindingsStatistics.builder();
        unusedAccessFindingsStatistics.accept(builder);
        return FindingsStatistics.fromUnusedAccessFindingsStatistics((UnusedAccessFindingsStatistics)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("externalAccessFindingsStatistics", EXTERNAL_ACCESS_FINDINGS_STATISTICS_FIELD);
        map.put("unusedAccessFindingsStatistics", UNUSED_ACCESS_FINDINGS_STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingsStatistics, T> g) {
        return obj -> g.apply((FindingsStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EXTERNAL_ACCESS_FINDINGS_STATISTICS,
        UNUSED_ACCESS_FINDINGS_STATISTICS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ExternalAccessFindingsStatistics externalAccessFindingsStatistics;
        private UnusedAccessFindingsStatistics unusedAccessFindingsStatistics;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FindingsStatistics model) {
            this.externalAccessFindingsStatistics(model.externalAccessFindingsStatistics);
            this.unusedAccessFindingsStatistics(model.unusedAccessFindingsStatistics);
        }

        public final ExternalAccessFindingsStatistics.Builder getExternalAccessFindingsStatistics() {
            return this.externalAccessFindingsStatistics != null ? this.externalAccessFindingsStatistics.toBuilder() : null;
        }

        public final void setExternalAccessFindingsStatistics(ExternalAccessFindingsStatistics.BuilderImpl externalAccessFindingsStatistics) {
            ExternalAccessFindingsStatistics oldValue = this.externalAccessFindingsStatistics;
            this.externalAccessFindingsStatistics = externalAccessFindingsStatistics != null ? externalAccessFindingsStatistics.build() : null;
            this.handleUnionValueChange(Type.EXTERNAL_ACCESS_FINDINGS_STATISTICS, oldValue, this.externalAccessFindingsStatistics);
        }

        @Override
        public final Builder externalAccessFindingsStatistics(ExternalAccessFindingsStatistics externalAccessFindingsStatistics) {
            ExternalAccessFindingsStatistics oldValue = this.externalAccessFindingsStatistics;
            this.externalAccessFindingsStatistics = externalAccessFindingsStatistics;
            this.handleUnionValueChange(Type.EXTERNAL_ACCESS_FINDINGS_STATISTICS, oldValue, this.externalAccessFindingsStatistics);
            return this;
        }

        public final UnusedAccessFindingsStatistics.Builder getUnusedAccessFindingsStatistics() {
            return this.unusedAccessFindingsStatistics != null ? this.unusedAccessFindingsStatistics.toBuilder() : null;
        }

        public final void setUnusedAccessFindingsStatistics(UnusedAccessFindingsStatistics.BuilderImpl unusedAccessFindingsStatistics) {
            UnusedAccessFindingsStatistics oldValue = this.unusedAccessFindingsStatistics;
            this.unusedAccessFindingsStatistics = unusedAccessFindingsStatistics != null ? unusedAccessFindingsStatistics.build() : null;
            this.handleUnionValueChange(Type.UNUSED_ACCESS_FINDINGS_STATISTICS, oldValue, this.unusedAccessFindingsStatistics);
        }

        @Override
        public final Builder unusedAccessFindingsStatistics(UnusedAccessFindingsStatistics unusedAccessFindingsStatistics) {
            UnusedAccessFindingsStatistics oldValue = this.unusedAccessFindingsStatistics;
            this.unusedAccessFindingsStatistics = unusedAccessFindingsStatistics;
            this.handleUnionValueChange(Type.UNUSED_ACCESS_FINDINGS_STATISTICS, oldValue, this.unusedAccessFindingsStatistics);
            return this;
        }

        public FindingsStatistics build() {
            return new FindingsStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingsStatistics> {
        public Builder externalAccessFindingsStatistics(ExternalAccessFindingsStatistics var1);

        default public Builder externalAccessFindingsStatistics(Consumer<ExternalAccessFindingsStatistics.Builder> externalAccessFindingsStatistics) {
            return this.externalAccessFindingsStatistics((ExternalAccessFindingsStatistics)((ExternalAccessFindingsStatistics.Builder)ExternalAccessFindingsStatistics.builder().applyMutation(externalAccessFindingsStatistics)).build());
        }

        public Builder unusedAccessFindingsStatistics(UnusedAccessFindingsStatistics var1);

        default public Builder unusedAccessFindingsStatistics(Consumer<UnusedAccessFindingsStatistics.Builder> unusedAccessFindingsStatistics) {
            return this.unusedAccessFindingsStatistics((UnusedAccessFindingsStatistics)((UnusedAccessFindingsStatistics.Builder)UnusedAccessFindingsStatistics.builder().applyMutation(unusedAccessFindingsStatistics)).build());
        }
    }
}

