/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.RegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Trail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Trail> {
    private static final SdkField<String> CLOUD_TRAIL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudTrailArn").getter(Trail.getter(Trail::cloudTrailArn)).setter(Trail.setter(Builder::cloudTrailArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudTrailArn").build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regions").getter(Trail.getter(Trail::regions)).setter(Trail.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALL_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allRegions").getter(Trail.getter(Trail::allRegions)).setter(Trail.setter(Builder::allRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allRegions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_TRAIL_ARN_FIELD, REGIONS_FIELD, ALL_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Trail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cloudTrailArn;
    private final List<String> regions;
    private final Boolean allRegions;

    private Trail(BuilderImpl builder) {
        this.cloudTrailArn = builder.cloudTrailArn;
        this.regions = builder.regions;
        this.allRegions = builder.allRegions;
    }

    public final String cloudTrailArn() {
        return this.cloudTrailArn;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public final Boolean allRegions() {
        return this.allRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudTrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allRegions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trail)) {
            return false;
        }
        Trail other = (Trail)obj;
        return Objects.equals(this.cloudTrailArn(), other.cloudTrailArn()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions()) && Objects.equals(this.allRegions(), other.allRegions());
    }

    public final String toString() {
        return ToString.builder((String)"Trail").add("CloudTrailArn", (Object)this.cloudTrailArn()).add("Regions", this.hasRegions() ? this.regions() : null).add("AllRegions", (Object)this.allRegions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudTrailArn": {
                return Optional.ofNullable(clazz.cast(this.cloudTrailArn()));
            }
            case "regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "allRegions": {
                return Optional.ofNullable(clazz.cast(this.allRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudTrailArn", CLOUD_TRAIL_ARN_FIELD);
        map.put("regions", REGIONS_FIELD);
        map.put("allRegions", ALL_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Trail, T> g) {
        return obj -> g.apply((Trail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudTrailArn;
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private Boolean allRegions;

        private BuilderImpl() {
        }

        private BuilderImpl(Trail model) {
            this.cloudTrailArn(model.cloudTrailArn);
            this.regions(model.regions);
            this.allRegions(model.allRegions);
        }

        public final String getCloudTrailArn() {
            return this.cloudTrailArn;
        }

        public final void setCloudTrailArn(String cloudTrailArn) {
            this.cloudTrailArn = cloudTrailArn;
        }

        @Override
        public final Builder cloudTrailArn(String cloudTrailArn) {
            this.cloudTrailArn = cloudTrailArn;
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final Boolean getAllRegions() {
            return this.allRegions;
        }

        public final void setAllRegions(Boolean allRegions) {
            this.allRegions = allRegions;
        }

        @Override
        public final Builder allRegions(Boolean allRegions) {
            this.allRegions = allRegions;
            return this;
        }

        public Trail build() {
            return new Trail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Trail> {
        public Builder cloudTrailArn(String var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder allRegions(Boolean var1);
    }
}

