/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue;
import software.amazon.awssdk.services.accessanalyzer.model.RdsDbClusterSnapshotAttributesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RdsDbClusterSnapshotConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RdsDbClusterSnapshotConfiguration> {
    private static final SdkField<Map<String, RdsDbClusterSnapshotAttributeValue>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(RdsDbClusterSnapshotConfiguration.getter(RdsDbClusterSnapshotConfiguration::attributes)).setter(RdsDbClusterSnapshotConfiguration.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RdsDbClusterSnapshotAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(RdsDbClusterSnapshotConfiguration.getter(RdsDbClusterSnapshotConfiguration::kmsKeyId)).setter(RdsDbClusterSnapshotConfiguration.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, RdsDbClusterSnapshotAttributeValue> attributes;
    private final String kmsKeyId;

    private RdsDbClusterSnapshotConfiguration(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, RdsDbClusterSnapshotAttributeValue> attributes() {
        return this.attributes;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsDbClusterSnapshotConfiguration)) {
            return false;
        }
        RdsDbClusterSnapshotConfiguration other = (RdsDbClusterSnapshotConfiguration)obj;
        return this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"RdsDbClusterSnapshotConfiguration").add("Attributes", this.hasAttributes() ? this.attributes() : null).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RdsDbClusterSnapshotConfiguration, T> g) {
        return obj -> g.apply((RdsDbClusterSnapshotConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, RdsDbClusterSnapshotAttributeValue> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsDbClusterSnapshotConfiguration model) {
            this.attributes(model.attributes);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final Map<String, RdsDbClusterSnapshotAttributeValue.Builder> getAttributes() {
            Map<String, RdsDbClusterSnapshotAttributeValue.Builder> result = RdsDbClusterSnapshotAttributesMapCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Map<String, RdsDbClusterSnapshotAttributeValue.BuilderImpl> attributes) {
            this.attributes = RdsDbClusterSnapshotAttributesMapCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Map<String, RdsDbClusterSnapshotAttributeValue> attributes) {
            this.attributes = RdsDbClusterSnapshotAttributesMapCopier.copy(attributes);
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public RdsDbClusterSnapshotConfiguration build() {
            return new RdsDbClusterSnapshotConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RdsDbClusterSnapshotConfiguration> {
        public Builder attributes(Map<String, RdsDbClusterSnapshotAttributeValue> var1);

        public Builder kmsKeyId(String var1);
    }
}

