/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReasonCode {
    AWS_SERVICE_ACCESS_DISABLED("AWS_SERVICE_ACCESS_DISABLED"),
    DELEGATED_ADMINISTRATOR_DEREGISTERED("DELEGATED_ADMINISTRATOR_DEREGISTERED"),
    ORGANIZATION_DELETED("ORGANIZATION_DELETED"),
    SERVICE_LINKED_ROLE_CREATION_FAILED("SERVICE_LINKED_ROLE_CREATION_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReasonCode> VALUE_MAP;
    private final String value;

    private ReasonCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReasonCode> knownValues() {
        EnumSet<ReasonCode> knownValues = EnumSet.allOf(ReasonCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReasonCode.class, ReasonCode::toString);
    }
}

