/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessCheckPolicyType {
    IDENTITY_POLICY("IDENTITY_POLICY"),
    RESOURCE_POLICY("RESOURCE_POLICY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessCheckPolicyType> VALUE_MAP;
    private final String value;

    private AccessCheckPolicyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessCheckPolicyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessCheckPolicyType> knownValues() {
        EnumSet<AccessCheckPolicyType> knownValues = EnumSet.allOf(AccessCheckPolicyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessCheckPolicyType.class, AccessCheckPolicyType::toString);
    }
}

