/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3PublicAccessBlockConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3PublicAccessBlockConfiguration> {
    private static final SdkField<Boolean> IGNORE_PUBLIC_ACLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ignorePublicAcls").getter(S3PublicAccessBlockConfiguration.getter(S3PublicAccessBlockConfiguration::ignorePublicAcls)).setter(S3PublicAccessBlockConfiguration.setter(Builder::ignorePublicAcls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignorePublicAcls").build()}).build();
    private static final SdkField<Boolean> RESTRICT_PUBLIC_BUCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("restrictPublicBuckets").getter(S3PublicAccessBlockConfiguration.getter(S3PublicAccessBlockConfiguration::restrictPublicBuckets)).setter(S3PublicAccessBlockConfiguration.setter(Builder::restrictPublicBuckets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restrictPublicBuckets").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IGNORE_PUBLIC_ACLS_FIELD, RESTRICT_PUBLIC_BUCKETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean ignorePublicAcls;
    private final Boolean restrictPublicBuckets;

    private S3PublicAccessBlockConfiguration(BuilderImpl builder) {
        this.ignorePublicAcls = builder.ignorePublicAcls;
        this.restrictPublicBuckets = builder.restrictPublicBuckets;
    }

    public final Boolean ignorePublicAcls() {
        return this.ignorePublicAcls;
    }

    public final Boolean restrictPublicBuckets() {
        return this.restrictPublicBuckets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ignorePublicAcls());
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictPublicBuckets());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3PublicAccessBlockConfiguration)) {
            return false;
        }
        S3PublicAccessBlockConfiguration other = (S3PublicAccessBlockConfiguration)obj;
        return Objects.equals(this.ignorePublicAcls(), other.ignorePublicAcls()) && Objects.equals(this.restrictPublicBuckets(), other.restrictPublicBuckets());
    }

    public final String toString() {
        return ToString.builder((String)"S3PublicAccessBlockConfiguration").add("IgnorePublicAcls", (Object)this.ignorePublicAcls()).add("RestrictPublicBuckets", (Object)this.restrictPublicBuckets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ignorePublicAcls": {
                return Optional.ofNullable(clazz.cast(this.ignorePublicAcls()));
            }
            case "restrictPublicBuckets": {
                return Optional.ofNullable(clazz.cast(this.restrictPublicBuckets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3PublicAccessBlockConfiguration, T> g) {
        return obj -> g.apply((S3PublicAccessBlockConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean ignorePublicAcls;
        private Boolean restrictPublicBuckets;

        private BuilderImpl() {
        }

        private BuilderImpl(S3PublicAccessBlockConfiguration model) {
            this.ignorePublicAcls(model.ignorePublicAcls);
            this.restrictPublicBuckets(model.restrictPublicBuckets);
        }

        public final Boolean getIgnorePublicAcls() {
            return this.ignorePublicAcls;
        }

        public final void setIgnorePublicAcls(Boolean ignorePublicAcls) {
            this.ignorePublicAcls = ignorePublicAcls;
        }

        @Override
        public final Builder ignorePublicAcls(Boolean ignorePublicAcls) {
            this.ignorePublicAcls = ignorePublicAcls;
            return this;
        }

        public final Boolean getRestrictPublicBuckets() {
            return this.restrictPublicBuckets;
        }

        public final void setRestrictPublicBuckets(Boolean restrictPublicBuckets) {
            this.restrictPublicBuckets = restrictPublicBuckets;
        }

        @Override
        public final Builder restrictPublicBuckets(Boolean restrictPublicBuckets) {
            this.restrictPublicBuckets = restrictPublicBuckets;
            return this;
        }

        public S3PublicAccessBlockConfiguration build() {
            return new S3PublicAccessBlockConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3PublicAccessBlockConfiguration> {
        public Builder ignorePublicAcls(Boolean var1);

        public Builder restrictPublicBuckets(Boolean var1);
    }
}

