/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerAsyncClient;
import software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewSummary;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsResponse;

public class ListAccessPreviewsPublisher
implements SdkPublisher<ListAccessPreviewsResponse> {
    private final AccessAnalyzerAsyncClient client;
    private final ListAccessPreviewsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessPreviewsPublisher(AccessAnalyzerAsyncClient client, ListAccessPreviewsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessPreviewsPublisher(AccessAnalyzerAsyncClient client, ListAccessPreviewsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessPreviewsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessPreviewsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccessPreviewSummary> accessPreviews() {
        Function<ListAccessPreviewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessPreviews() != null) {
                return response.accessPreviews().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccessPreviewsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccessPreviewsResponseFetcher
    implements AsyncPageFetcher<ListAccessPreviewsResponse> {
        private ListAccessPreviewsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessPreviewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessPreviewsResponse> nextPage(ListAccessPreviewsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessPreviewsPublisher.this.client.listAccessPreviews(ListAccessPreviewsPublisher.this.firstRequest);
            }
            return ListAccessPreviewsPublisher.this.client.listAccessPreviews((ListAccessPreviewsRequest)((Object)ListAccessPreviewsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

