/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.ValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Criterion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Criterion> {
    private static final SdkField<List<String>> CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("contains").getter(Criterion.getter(Criterion::contains)).setter(Criterion.setter(Builder::contains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eq").getter(Criterion.getter(Criterion::eq)).setter(Criterion.setter(Builder::eq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eq").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> EXISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("exists").getter(Criterion.getter(Criterion::exists)).setter(Criterion.setter(Builder::exists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exists").build()}).build();
    private static final SdkField<List<String>> NEQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("neq").getter(Criterion.getter(Criterion::neq)).setter(Criterion.setter(Builder::neq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neq").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINS_FIELD, EQ_FIELD, EXISTS_FIELD, NEQ_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> contains;
    private final List<String> eq;
    private final Boolean exists;
    private final List<String> neq;

    private Criterion(BuilderImpl builder) {
        this.contains = builder.contains;
        this.eq = builder.eq;
        this.exists = builder.exists;
        this.neq = builder.neq;
    }

    public final boolean hasContains() {
        return this.contains != null && !(this.contains instanceof SdkAutoConstructList);
    }

    public final List<String> contains() {
        return this.contains;
    }

    public final boolean hasEq() {
        return this.eq != null && !(this.eq instanceof SdkAutoConstructList);
    }

    public final List<String> eq() {
        return this.eq;
    }

    public final Boolean exists() {
        return this.exists;
    }

    public final boolean hasNeq() {
        return this.neq != null && !(this.neq instanceof SdkAutoConstructList);
    }

    public final List<String> neq() {
        return this.neq;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContains() ? this.contains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEq() ? this.eq() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.exists());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNeq() ? this.neq() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Criterion)) {
            return false;
        }
        Criterion other = (Criterion)obj;
        return this.hasContains() == other.hasContains() && Objects.equals(this.contains(), other.contains()) && this.hasEq() == other.hasEq() && Objects.equals(this.eq(), other.eq()) && Objects.equals(this.exists(), other.exists()) && this.hasNeq() == other.hasNeq() && Objects.equals(this.neq(), other.neq());
    }

    public final String toString() {
        return ToString.builder((String)"Criterion").add("Contains", this.hasContains() ? this.contains() : null).add("Eq", this.hasEq() ? this.eq() : null).add("Exists", (Object)this.exists()).add("Neq", this.hasNeq() ? this.neq() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contains": {
                return Optional.ofNullable(clazz.cast(this.contains()));
            }
            case "eq": {
                return Optional.ofNullable(clazz.cast(this.eq()));
            }
            case "exists": {
                return Optional.ofNullable(clazz.cast(this.exists()));
            }
            case "neq": {
                return Optional.ofNullable(clazz.cast(this.neq()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Criterion, T> g) {
        return obj -> g.apply((Criterion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> contains = DefaultSdkAutoConstructList.getInstance();
        private List<String> eq = DefaultSdkAutoConstructList.getInstance();
        private Boolean exists;
        private List<String> neq = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Criterion model) {
            this.contains(model.contains);
            this.eq(model.eq);
            this.exists(model.exists);
            this.neq(model.neq);
        }

        public final Collection<String> getContains() {
            if (this.contains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contains;
        }

        @Override
        public final Builder contains(Collection<String> contains) {
            this.contains = ValueListCopier.copy(contains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contains(String ... contains) {
            this.contains(Arrays.asList(contains));
            return this;
        }

        public final void setContains(Collection<String> contains) {
            this.contains = ValueListCopier.copy(contains);
        }

        public final Collection<String> getEq() {
            if (this.eq instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eq;
        }

        @Override
        public final Builder eq(Collection<String> eq) {
            this.eq = ValueListCopier.copy(eq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eq(String ... eq) {
            this.eq(Arrays.asList(eq));
            return this;
        }

        public final void setEq(Collection<String> eq) {
            this.eq = ValueListCopier.copy(eq);
        }

        public final Boolean getExists() {
            return this.exists;
        }

        @Override
        public final Builder exists(Boolean exists) {
            this.exists = exists;
            return this;
        }

        public final void setExists(Boolean exists) {
            this.exists = exists;
        }

        public final Collection<String> getNeq() {
            if (this.neq instanceof SdkAutoConstructList) {
                return null;
            }
            return this.neq;
        }

        @Override
        public final Builder neq(Collection<String> neq) {
            this.neq = ValueListCopier.copy(neq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neq(String ... neq) {
            this.neq(Arrays.asList(neq));
            return this;
        }

        public final void setNeq(Collection<String> neq) {
            this.neq = ValueListCopier.copy(neq);
        }

        public Criterion build() {
            return new Criterion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Criterion> {
        public Builder contains(Collection<String> var1);

        public Builder contains(String ... var1);

        public Builder eq(Collection<String> var1);

        public Builder eq(String ... var1);

        public Builder exists(Boolean var1);

        public Builder neq(Collection<String> var1);

        public Builder neq(String ... var1);
    }
}

