/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Locale {
    DE("DE"),
    EN("EN"),
    ES("ES"),
    FR("FR"),
    IT("IT"),
    JA("JA"),
    KO("KO"),
    PT_BR("PT_BR"),
    ZH_CN("ZH_CN"),
    ZH_TW("ZH_TW"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Locale(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Locale fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Locale.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Locale> knownValues() {
        return Stream.of(Locale.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

