/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewSummary;
import software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessPreviewsResponse
extends AccessAnalyzerResponse
implements ToCopyableBuilder<Builder, ListAccessPreviewsResponse> {
    private static final SdkField<List<AccessPreviewSummary>> ACCESS_PREVIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accessPreviews").getter(ListAccessPreviewsResponse.getter(ListAccessPreviewsResponse::accessPreviews)).setter(ListAccessPreviewsResponse.setter(Builder::accessPreviews)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPreviews").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessPreviewSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAccessPreviewsResponse.getter(ListAccessPreviewsResponse::nextToken)).setter(ListAccessPreviewsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_PREVIEWS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AccessPreviewSummary> accessPreviews;
    private final String nextToken;

    private ListAccessPreviewsResponse(BuilderImpl builder) {
        super(builder);
        this.accessPreviews = builder.accessPreviews;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccessPreviews() {
        return this.accessPreviews != null && !(this.accessPreviews instanceof SdkAutoConstructList);
    }

    public final List<AccessPreviewSummary> accessPreviews() {
        return this.accessPreviews;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessPreviews() ? this.accessPreviews() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessPreviewsResponse)) {
            return false;
        }
        ListAccessPreviewsResponse other = (ListAccessPreviewsResponse)((Object)obj);
        return this.hasAccessPreviews() == other.hasAccessPreviews() && Objects.equals(this.accessPreviews(), other.accessPreviews()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessPreviewsResponse").add("AccessPreviews", this.hasAccessPreviews() ? this.accessPreviews() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessPreviews": {
                return Optional.ofNullable(clazz.cast(this.accessPreviews()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessPreviewsResponse, T> g) {
        return obj -> g.apply((ListAccessPreviewsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerResponse.BuilderImpl
    implements Builder {
        private List<AccessPreviewSummary> accessPreviews = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessPreviewsResponse model) {
            super(model);
            this.accessPreviews(model.accessPreviews);
            this.nextToken(model.nextToken);
        }

        public final Collection<AccessPreviewSummary.Builder> getAccessPreviews() {
            if (this.accessPreviews instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accessPreviews != null ? (Collection)this.accessPreviews.stream().map(AccessPreviewSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accessPreviews(Collection<AccessPreviewSummary> accessPreviews) {
            this.accessPreviews = AccessPreviewsListCopier.copy(accessPreviews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPreviews(AccessPreviewSummary ... accessPreviews) {
            this.accessPreviews(Arrays.asList(accessPreviews));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPreviews(Consumer<AccessPreviewSummary.Builder> ... accessPreviews) {
            this.accessPreviews(Stream.of(accessPreviews).map(c -> (AccessPreviewSummary)((AccessPreviewSummary.Builder)AccessPreviewSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccessPreviews(Collection<AccessPreviewSummary.BuilderImpl> accessPreviews) {
            this.accessPreviews = AccessPreviewsListCopier.copyFromBuilder(accessPreviews);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAccessPreviewsResponse build() {
            return new ListAccessPreviewsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AccessAnalyzerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessPreviewsResponse> {
        public Builder accessPreviews(Collection<AccessPreviewSummary> var1);

        public Builder accessPreviews(AccessPreviewSummary ... var1);

        public Builder accessPreviews(Consumer<AccessPreviewSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

