/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplyArchiveRuleRequest
extends AccessAnalyzerRequest
implements ToCopyableBuilder<Builder, ApplyArchiveRuleRequest> {
    private static final SdkField<String> ANALYZER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analyzerArn").getter(ApplyArchiveRuleRequest.getter(ApplyArchiveRuleRequest::analyzerArn)).setter(ApplyArchiveRuleRequest.setter(Builder::analyzerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzerArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(ApplyArchiveRuleRequest.getter(ApplyArchiveRuleRequest::clientToken)).setter(ApplyArchiveRuleRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleName").getter(ApplyArchiveRuleRequest.getter(ApplyArchiveRuleRequest::ruleName)).setter(ApplyArchiveRuleRequest.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_ARN_FIELD, CLIENT_TOKEN_FIELD, RULE_NAME_FIELD));
    private final String analyzerArn;
    private final String clientToken;
    private final String ruleName;

    private ApplyArchiveRuleRequest(BuilderImpl builder) {
        super(builder);
        this.analyzerArn = builder.analyzerArn;
        this.clientToken = builder.clientToken;
        this.ruleName = builder.ruleName;
    }

    public String analyzerArn() {
        return this.analyzerArn;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String ruleName() {
        return this.ruleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyArchiveRuleRequest)) {
            return false;
        }
        ApplyArchiveRuleRequest other = (ApplyArchiveRuleRequest)((Object)obj);
        return Objects.equals(this.analyzerArn(), other.analyzerArn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.ruleName(), other.ruleName());
    }

    public String toString() {
        return ToString.builder((String)"ApplyArchiveRuleRequest").add("AnalyzerArn", (Object)this.analyzerArn()).add("ClientToken", (Object)this.clientToken()).add("RuleName", (Object)this.ruleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analyzerArn": {
                return Optional.ofNullable(clazz.cast(this.analyzerArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ruleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplyArchiveRuleRequest, T> g) {
        return obj -> g.apply((ApplyArchiveRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerRequest.BuilderImpl
    implements Builder {
        private String analyzerArn;
        private String clientToken;
        private String ruleName;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyArchiveRuleRequest model) {
            super(model);
            this.analyzerArn(model.analyzerArn);
            this.clientToken(model.clientToken);
            this.ruleName(model.ruleName);
        }

        public final String getAnalyzerArn() {
            return this.analyzerArn;
        }

        @Override
        public final Builder analyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
            return this;
        }

        public final void setAnalyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ApplyArchiveRuleRequest build() {
            return new ApplyArchiveRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AccessAnalyzerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ApplyArchiveRuleRequest> {
        public Builder analyzerArn(String var1);

        public Builder clientToken(String var1);

        public Builder ruleName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

