/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAnalyzedResourceResponse
extends AccessAnalyzerResponse
implements ToCopyableBuilder<Builder, GetAnalyzedResourceResponse> {
    private static final SdkField<AnalyzedResource> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetAnalyzedResourceResponse.getter(GetAnalyzedResourceResponse::resource)).setter(GetAnalyzedResourceResponse.setter(Builder::resource)).constructor(AnalyzedResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD));
    private final AnalyzedResource resource;

    private GetAnalyzedResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resource = builder.resource;
    }

    public AnalyzedResource resource() {
        return this.resource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnalyzedResourceResponse)) {
            return false;
        }
        GetAnalyzedResourceResponse other = (GetAnalyzedResourceResponse)((Object)obj);
        return Objects.equals(this.resource(), other.resource());
    }

    public String toString() {
        return ToString.builder((String)"GetAnalyzedResourceResponse").add("Resource", (Object)this.resource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAnalyzedResourceResponse, T> g) {
        return obj -> g.apply((GetAnalyzedResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerResponse.BuilderImpl
    implements Builder {
        private AnalyzedResource resource;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnalyzedResourceResponse model) {
            super(model);
            this.resource(model.resource);
        }

        public final AnalyzedResource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        @Override
        public final Builder resource(AnalyzedResource resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(AnalyzedResource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public GetAnalyzedResourceResponse build() {
            return new GetAnalyzedResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AccessAnalyzerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAnalyzedResourceResponse> {
        public Builder resource(AnalyzedResource var1);

        default public Builder resource(Consumer<AnalyzedResource.Builder> resource) {
            return this.resource((AnalyzedResource)((AnalyzedResource.Builder)AnalyzedResource.builder().applyMutation(resource)).build());
        }
    }
}

