/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResourceType {
    AWS_IAM_ROLE("AWS::IAM::Role"),
    AWS_KMS_KEY("AWS::KMS::Key"),
    AWS_LAMBDA_FUNCTION("AWS::Lambda::Function"),
    AWS_LAMBDA_LAYER_VERSION("AWS::Lambda::LayerVersion"),
    AWS_S3_BUCKET("AWS::S3::Bucket"),
    AWS_SQS_QUEUE("AWS::SQS::Queue"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceType> knownValues() {
        return Stream.of(ResourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

