/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFindingResponse extends AccessAnalyzerResponse implements
        ToCopyableBuilder<GetFindingResponse.Builder, GetFindingResponse> {
    private static final SdkField<Finding> FINDING_FIELD = SdkField.<Finding> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetFindingResponse::finding)).setter(setter(Builder::finding)).constructor(Finding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finding").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_FIELD));

    private final Finding finding;

    private GetFindingResponse(BuilderImpl builder) {
        super(builder);
        this.finding = builder.finding;
    }

    /**
     * <p>
     * A <code>finding</code> object that contains finding details.
     * </p>
     * 
     * @return A <code>finding</code> object that contains finding details.
     */
    public Finding finding() {
        return finding;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(finding());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingResponse)) {
            return false;
        }
        GetFindingResponse other = (GetFindingResponse) obj;
        return Objects.equals(finding(), other.finding());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetFindingResponse").add("Finding", finding()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "finding":
            return Optional.ofNullable(clazz.cast(finding()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingResponse, T> g) {
        return obj -> g.apply((GetFindingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFindingResponse> {
        /**
         * <p>
         * A <code>finding</code> object that contains finding details.
         * </p>
         * 
         * @param finding
         *        A <code>finding</code> object that contains finding details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finding(Finding finding);

        /**
         * <p>
         * A <code>finding</code> object that contains finding details.
         * </p>
         * This is a convenience that creates an instance of the {@link Finding.Builder} avoiding the need to create one
         * manually via {@link Finding#builder()}.
         *
         * When the {@link Consumer} completes, {@link Finding.Builder#build()} is called immediately and its result is
         * passed to {@link #finding(Finding)}.
         * 
         * @param finding
         *        a consumer that will call methods on {@link Finding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #finding(Finding)
         */
        default Builder finding(Consumer<Finding.Builder> finding) {
            return finding(Finding.builder().applyMutation(finding).build());
        }
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private Finding finding;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingResponse model) {
            super(model);
            finding(model.finding);
        }

        public final Finding.Builder getFinding() {
            return finding != null ? finding.toBuilder() : null;
        }

        @Override
        public final Builder finding(Finding finding) {
            this.finding = finding;
            return this;
        }

        public final void setFinding(Finding.BuilderImpl finding) {
            this.finding = finding != null ? finding.build() : null;
        }

        @Override
        public GetFindingResponse build() {
            return new GetFindingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
