/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awsconstructs.services.s3stepfunctions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.cloudtrail.Trail;
import software.amazon.awscdk.services.cloudwatch.Alarm;
import software.amazon.awscdk.services.events.RuleProps;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.awscdk.services.logs.LogGroupProps;
import software.amazon.awscdk.services.s3.Bucket;
import software.amazon.awscdk.services.s3.BucketProps;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.stepfunctions.StateMachine;
import software.amazon.awscdk.services.stepfunctions.StateMachineProps;
import software.amazon.awsconstructs.services.s3stepfunctions.$Module;
import software.amazon.awsconstructs.services.s3stepfunctions.S3ToStepfunctionsProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-solutions-constructs/aws-s3-stepfunctions.S3ToStepfunctions")
public class S3ToStepfunctions
extends Construct {
    protected S3ToStepfunctions(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3ToStepfunctions(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public S3ToStepfunctions(@NotNull Construct scope, @NotNull String id, @NotNull S3ToStepfunctionsProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IBucket getS3BucketInterface() {
        return (IBucket)Kernel.get((Object)((Object)this), (String)"s3BucketInterface", (NativeType)NativeType.forClass(IBucket.class));
    }

    @NotNull
    public StateMachine getStateMachine() {
        return (StateMachine)Kernel.get((Object)((Object)this), (String)"stateMachine", (NativeType)NativeType.forClass(StateMachine.class));
    }

    @NotNull
    public ILogGroup getStateMachineLogGroup() {
        return (ILogGroup)Kernel.get((Object)((Object)this), (String)"stateMachineLogGroup", (NativeType)NativeType.forClass(ILogGroup.class));
    }

    @Nullable
    public Trail getCloudtrail() {
        return (Trail)Kernel.get((Object)((Object)this), (String)"cloudtrail", (NativeType)NativeType.forClass(Trail.class));
    }

    @Nullable
    public Bucket getCloudtrailBucket() {
        return (Bucket)Kernel.get((Object)((Object)this), (String)"cloudtrailBucket", (NativeType)NativeType.forClass(Bucket.class));
    }

    @Nullable
    public Bucket getCloudtrailLoggingBucket() {
        return (Bucket)Kernel.get((Object)((Object)this), (String)"cloudtrailLoggingBucket", (NativeType)NativeType.forClass(Bucket.class));
    }

    @Nullable
    public List<Alarm> getCloudwatchAlarms() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"cloudwatchAlarms", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Alarm.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public Bucket getS3Bucket() {
        return (Bucket)Kernel.get((Object)((Object)this), (String)"s3Bucket", (NativeType)NativeType.forClass(Bucket.class));
    }

    @Nullable
    public Bucket getS3LoggingBucket() {
        return (Bucket)Kernel.get((Object)((Object)this), (String)"s3LoggingBucket", (NativeType)NativeType.forClass(Bucket.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<S3ToStepfunctions> {
        private final Construct scope;
        private final String id;
        private final S3ToStepfunctionsProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new S3ToStepfunctionsProps.Builder();
        }

        public Builder stateMachineProps(StateMachineProps stateMachineProps) {
            this.props.stateMachineProps(stateMachineProps);
            return this;
        }

        public Builder bucketProps(BucketProps bucketProps) {
            this.props.bucketProps(bucketProps);
            return this;
        }

        public Builder createCloudWatchAlarms(Boolean createCloudWatchAlarms) {
            this.props.createCloudWatchAlarms(createCloudWatchAlarms);
            return this;
        }

        public Builder deployCloudTrail(Boolean deployCloudTrail) {
            this.props.deployCloudTrail(deployCloudTrail);
            return this;
        }

        public Builder eventRuleProps(RuleProps eventRuleProps) {
            this.props.eventRuleProps(eventRuleProps);
            return this;
        }

        public Builder existingBucketObj(IBucket existingBucketObj) {
            this.props.existingBucketObj(existingBucketObj);
            return this;
        }

        public Builder loggingBucketProps(BucketProps loggingBucketProps) {
            this.props.loggingBucketProps(loggingBucketProps);
            return this;
        }

        public Builder logGroupProps(LogGroupProps logGroupProps) {
            this.props.logGroupProps(logGroupProps);
            return this;
        }

        public Builder logS3AccessLogs(Boolean logS3AccessLogs) {
            this.props.logS3AccessLogs(logS3AccessLogs);
            return this;
        }

        public S3ToStepfunctions build() {
            return new S3ToStepfunctions(this.scope, this.id, this.props.build());
        }
    }
}

