package software.amazon.awscdk.services.stepfunctions;

/**
 * Define a Task state in the state machine.
 * <p>
 * Reaching a Task state causes some work to be executed, represented by the
 * Task's resource property. Task constructs represent a generic Amazon
 * States Language Task.
 * <p>
 * For some resource types, more specific subclasses of Task may be available
 * which are more convenient to use.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:13.495Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.TaskStateBase")
public abstract class TaskStateBase extends software.amazon.awscdk.services.stepfunctions.State implements software.amazon.awscdk.services.stepfunctions.INextable {

    protected TaskStateBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TaskStateBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected TaskStateBase(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a recovery handler for this state.
     * <p>
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     * <p>
     * @param handler This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskStateBase addCatch(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable handler, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.CatchProps props) {
        return this.jsiiCall("addCatch", software.amazon.awscdk.services.stepfunctions.TaskStateBase.class, new Object[] { java.util.Objects.requireNonNull(handler, "handler is required"), props });
    }

    /**
     * Add a recovery handler for this state.
     * <p>
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     * <p>
     * @param handler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskStateBase addCatch(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable handler) {
        return this.jsiiCall("addCatch", software.amazon.awscdk.services.stepfunctions.TaskStateBase.class, new Object[] { java.util.Objects.requireNonNull(handler, "handler is required") });
    }

    /**
     * Add retry configuration for this state.
     * <p>
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskStateBase addRetry(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.RetryProps props) {
        return this.jsiiCall("addRetry", software.amazon.awscdk.services.stepfunctions.TaskStateBase.class, new Object[] { props });
    }

    /**
     * Add retry configuration for this state.
     * <p>
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskStateBase addRetry() {
        return this.jsiiCall("addRetry", software.amazon.awscdk.services.stepfunctions.TaskStateBase.class);
    }

    /**
     * Return the given named metric for this Task.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Task.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Metric for the number of times this activity fails.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFailed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricFailed", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of times this activity fails.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFailed() {
        return this.jsiiCall("metricFailed", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of times the heartbeat times out for this activity.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHeartbeatTimedOut(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricHeartbeatTimedOut", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of times the heartbeat times out for this activity.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHeartbeatTimedOut() {
        return this.jsiiCall("metricHeartbeatTimedOut", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The interval, in milliseconds, between the time the Task starts and the time it closes.
     * <p>
     * Default: - average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRunTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricRunTime", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The interval, in milliseconds, between the time the Task starts and the time it closes.
     * <p>
     * Default: - average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRunTime() {
        return this.jsiiCall("metricRunTime", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of times this activity is scheduled.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricScheduled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricScheduled", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of times this activity is scheduled.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricScheduled() {
        return this.jsiiCall("metricScheduled", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The interval, in milliseconds, for which the activity stays in the schedule state.
     * <p>
     * Default: - average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricScheduleTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricScheduleTime", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The interval, in milliseconds, for which the activity stays in the schedule state.
     * <p>
     * Default: - average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricScheduleTime() {
        return this.jsiiCall("metricScheduleTime", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of times this activity is started.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricStarted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricStarted", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of times this activity is started.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricStarted() {
        return this.jsiiCall("metricStarted", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of times this activity succeeds.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSucceeded(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricSucceeded", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of times this activity succeeds.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSucceeded() {
        return this.jsiiCall("metricSucceeded", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The interval, in milliseconds, between the time the activity is scheduled and the time it closes.
     * <p>
     * Default: - average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricTime", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The interval, in milliseconds, between the time the activity is scheduled and the time it closes.
     * <p>
     * Default: - average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTime() {
        return this.jsiiCall("metricTime", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of times this activity times out.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTimedOut(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricTimedOut", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of times this activity times out.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTimedOut() {
        return this.jsiiCall("metricTimedOut", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Continue normal execution with the given state.
     * <p>
     * @param next This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Chain next(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return this.jsiiCall("next", software.amazon.awscdk.services.stepfunctions.Chain.class, new Object[] { java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Return the Amazon States Language object for this state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson() {
        return this.jsiiCall("toStateJson", com.fasterxml.jackson.databind.node.ObjectNode.class);
    }

    /**
     * Called whenever this state is bound to a graph.
     * <p>
     * Can be overridden by subclasses.
     * <p>
     * @param graph This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected void whenBoundToGraph(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateGraph graph) {
        this.jsiiCall("whenBoundToGraph", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(graph, "graph is required") });
    }

    /**
     * Continuable states of this Chainable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("endStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.INextable.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig getTaskMetrics();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected abstract @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getTaskPolicies();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.stepfunctions.TaskStateBase {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig getTaskMetrics() {
            return this.jsiiGet("taskMetrics", software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig.class);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        protected @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getTaskPolicies() {
            return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)(this.jsiiGet("taskPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * The chainable end state(s) of this chainable.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
            return java.util.Collections.unmodifiableList(this.jsiiGet("endStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.INextable.class))));
        }

        /**
         * Descriptive identifier for this chainable.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getId() {
            return this.jsiiGet("id", java.lang.String.class);
        }

        /**
         * The start state of this chainable.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State getStartState() {
            return this.jsiiGet("startState", software.amazon.awscdk.services.stepfunctions.State.class);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Go to the indicated state after this state.
         * <p>
         * @return The chain of states built up
         * @param state This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Chain next(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable state) {
            return this.jsiiCall("next", software.amazon.awscdk.services.stepfunctions.Chain.class, new Object[] { java.util.Objects.requireNonNull(state, "state is required") });
        }

        /**
         * Render the state as JSON.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson() {
            return this.jsiiCall("toStateJson", com.fasterxml.jackson.databind.node.ObjectNode.class);
        }
    }
}
