package software.amazon.awscdk.services.stepfunctions;

/**
 * Defines what execution history events are logged and where they are logged.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:13.485Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.LogOptions")
@software.amazon.jsii.Jsii.Proxy(LogOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The log group where the execution history events will be logged.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup getDestination();

    /**
     * Determines whether execution data is included in your log.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeExecutionData() {
        return null;
    }

    /**
     * Defines which category of execution history events are logged.
     * <p>
     * Default: ERROR
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.LogLevel getLevel() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogOptions> {
        private software.amazon.awscdk.services.logs.ILogGroup destination;
        private java.lang.Boolean includeExecutionData;
        private software.amazon.awscdk.services.stepfunctions.LogLevel level;

        /**
         * Sets the value of {@link LogOptions#getDestination}
         * @param destination The log group where the execution history events will be logged. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(software.amazon.awscdk.services.logs.ILogGroup destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link LogOptions#getIncludeExecutionData}
         * @param includeExecutionData Determines whether execution data is included in your log.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeExecutionData(java.lang.Boolean includeExecutionData) {
            this.includeExecutionData = includeExecutionData;
            return this;
        }

        /**
         * Sets the value of {@link LogOptions#getLevel}
         * @param level Defines which category of execution history events are logged.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder level(software.amazon.awscdk.services.stepfunctions.LogLevel level) {
            this.level = level;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogOptions build() {
            return new Jsii$Proxy(destination, includeExecutionData, level);
        }
    }

    /**
     * An implementation for {@link LogOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogOptions {
        private final software.amazon.awscdk.services.logs.ILogGroup destination;
        private final java.lang.Boolean includeExecutionData;
        private final software.amazon.awscdk.services.stepfunctions.LogLevel level;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destination = this.jsiiGet("destination", software.amazon.awscdk.services.logs.ILogGroup.class);
            this.includeExecutionData = this.jsiiGet("includeExecutionData", java.lang.Boolean.class);
            this.level = this.jsiiGet("level", software.amazon.awscdk.services.stepfunctions.LogLevel.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.logs.ILogGroup destination, final java.lang.Boolean includeExecutionData, final software.amazon.awscdk.services.stepfunctions.LogLevel level) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destination = java.util.Objects.requireNonNull(destination, "destination is required");
            this.includeExecutionData = includeExecutionData;
            this.level = level;
        }

        @Override
        public software.amazon.awscdk.services.logs.ILogGroup getDestination() {
            return this.destination;
        }

        @Override
        public java.lang.Boolean getIncludeExecutionData() {
            return this.includeExecutionData;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.LogLevel getLevel() {
            return this.level;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destination", om.valueToTree(this.getDestination()));
            if (this.getIncludeExecutionData() != null) {
                data.set("includeExecutionData", om.valueToTree(this.getIncludeExecutionData()));
            }
            if (this.getLevel() != null) {
                data.set("level", om.valueToTree(this.getLevel()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions.LogOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogOptions.Jsii$Proxy that = (LogOptions.Jsii$Proxy) o;

            if (!destination.equals(that.destination)) return false;
            if (this.includeExecutionData != null ? !this.includeExecutionData.equals(that.includeExecutionData) : that.includeExecutionData != null) return false;
            return this.level != null ? this.level.equals(that.level) : that.level == null;
        }

        @Override
        public int hashCode() {
            int result = this.destination.hashCode();
            result = 31 * result + (this.includeExecutionData != null ? this.includeExecutionData.hashCode() : 0);
            result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
            return result;
        }
    }
}
