/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.stepfunctions.IChainable;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface StateMachineProps
extends JsiiSerializable {
    public IChainable getDefinition();

    public IRole getRole();

    public String getStateMachineName();

    public Duration getTimeout();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IChainable _definition;
        @Nullable
        private IRole _role;
        @Nullable
        private String _stateMachineName;
        @Nullable
        private Duration _timeout;

        public Builder withDefinition(IChainable value) {
            this._definition = Objects.requireNonNull(value, "definition is required");
            return this;
        }

        public Builder withRole(@Nullable IRole value) {
            this._role = value;
            return this;
        }

        public Builder withStateMachineName(@Nullable String value) {
            this._stateMachineName = value;
            return this;
        }

        public Builder withTimeout(@Nullable Duration value) {
            this._timeout = value;
            return this;
        }

        public StateMachineProps build() {
            return new StateMachineProps(){
                private final IChainable $definition;
                @Nullable
                private final IRole $role;
                @Nullable
                private final String $stateMachineName;
                @Nullable
                private final Duration $timeout;
                {
                    this.$definition = Objects.requireNonNull(_definition, "definition is required");
                    this.$role = _role;
                    this.$stateMachineName = _stateMachineName;
                    this.$timeout = _timeout;
                }

                @Override
                public IChainable getDefinition() {
                    return this.$definition;
                }

                @Override
                public IRole getRole() {
                    return this.$role;
                }

                @Override
                public String getStateMachineName() {
                    return this.$stateMachineName;
                }

                @Override
                public Duration getTimeout() {
                    return this.$timeout;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("definition", om.valueToTree((Object)this.getDefinition()));
                    if (this.getRole() != null) {
                        obj.set("role", om.valueToTree((Object)this.getRole()));
                    }
                    if (this.getStateMachineName() != null) {
                        obj.set("stateMachineName", om.valueToTree((Object)this.getStateMachineName()));
                    }
                    if (this.getTimeout() != null) {
                        obj.set("timeout", om.valueToTree((Object)this.getTimeout()));
                    }
                    return obj;
                }
            };
        }
    }
}

