/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface StepFunctionsTaskConfig
extends JsiiSerializable {
    public String getResourceArn();

    public Duration getHeartbeat();

    public Map<String, Object> getMetricDimensions();

    public String getMetricPrefixPlural();

    public String getMetricPrefixSingular();

    public Map<String, Object> getParameters();

    public List<PolicyStatement> getPolicyStatements();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _resourceArn;
        @Nullable
        private Duration _heartbeat;
        @Nullable
        private Map<String, Object> _metricDimensions;
        @Nullable
        private String _metricPrefixPlural;
        @Nullable
        private String _metricPrefixSingular;
        @Nullable
        private Map<String, Object> _parameters;
        @Nullable
        private List<PolicyStatement> _policyStatements;

        public Builder withResourceArn(String value) {
            this._resourceArn = Objects.requireNonNull(value, "resourceArn is required");
            return this;
        }

        public Builder withHeartbeat(@Nullable Duration value) {
            this._heartbeat = value;
            return this;
        }

        public Builder withMetricDimensions(@Nullable Map<String, Object> value) {
            this._metricDimensions = value;
            return this;
        }

        public Builder withMetricPrefixPlural(@Nullable String value) {
            this._metricPrefixPlural = value;
            return this;
        }

        public Builder withMetricPrefixSingular(@Nullable String value) {
            this._metricPrefixSingular = value;
            return this;
        }

        public Builder withParameters(@Nullable Map<String, Object> value) {
            this._parameters = value;
            return this;
        }

        public Builder withPolicyStatements(@Nullable List<PolicyStatement> value) {
            this._policyStatements = value;
            return this;
        }

        public StepFunctionsTaskConfig build() {
            return new StepFunctionsTaskConfig(){
                private final String $resourceArn;
                @Nullable
                private final Duration $heartbeat;
                @Nullable
                private final Map<String, Object> $metricDimensions;
                @Nullable
                private final String $metricPrefixPlural;
                @Nullable
                private final String $metricPrefixSingular;
                @Nullable
                private final Map<String, Object> $parameters;
                @Nullable
                private final List<PolicyStatement> $policyStatements;
                {
                    this.$resourceArn = Objects.requireNonNull(_resourceArn, "resourceArn is required");
                    this.$heartbeat = _heartbeat;
                    this.$metricDimensions = _metricDimensions;
                    this.$metricPrefixPlural = _metricPrefixPlural;
                    this.$metricPrefixSingular = _metricPrefixSingular;
                    this.$parameters = _parameters;
                    this.$policyStatements = _policyStatements;
                }

                @Override
                public String getResourceArn() {
                    return this.$resourceArn;
                }

                @Override
                public Duration getHeartbeat() {
                    return this.$heartbeat;
                }

                @Override
                public Map<String, Object> getMetricDimensions() {
                    return this.$metricDimensions;
                }

                @Override
                public String getMetricPrefixPlural() {
                    return this.$metricPrefixPlural;
                }

                @Override
                public String getMetricPrefixSingular() {
                    return this.$metricPrefixSingular;
                }

                @Override
                public Map<String, Object> getParameters() {
                    return this.$parameters;
                }

                @Override
                public List<PolicyStatement> getPolicyStatements() {
                    return this.$policyStatements;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("resourceArn", om.valueToTree((Object)this.getResourceArn()));
                    if (this.getHeartbeat() != null) {
                        obj.set("heartbeat", om.valueToTree((Object)this.getHeartbeat()));
                    }
                    if (this.getMetricDimensions() != null) {
                        obj.set("metricDimensions", om.valueToTree(this.getMetricDimensions()));
                    }
                    if (this.getMetricPrefixPlural() != null) {
                        obj.set("metricPrefixPlural", om.valueToTree((Object)this.getMetricPrefixPlural()));
                    }
                    if (this.getMetricPrefixSingular() != null) {
                        obj.set("metricPrefixSingular", om.valueToTree((Object)this.getMetricPrefixSingular()));
                    }
                    if (this.getParameters() != null) {
                        obj.set("parameters", om.valueToTree(this.getParameters()));
                    }
                    if (this.getPolicyStatements() != null) {
                        obj.set("policyStatements", om.valueToTree(this.getPolicyStatements()));
                    }
                    return obj;
                }
            };
        }
    }
}

