/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface TaskProps
extends JsiiSerializable {
    public IStepFunctionsTask getTask();

    public String getComment();

    public String getInputPath();

    public String getOutputPath();

    public String getResultPath();

    public Number getTimeoutSeconds();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IStepFunctionsTask _task;
        @Nullable
        private String _comment;
        @Nullable
        private String _inputPath;
        @Nullable
        private String _outputPath;
        @Nullable
        private String _resultPath;
        @Nullable
        private Number _timeoutSeconds;

        public Builder withTask(IStepFunctionsTask value) {
            this._task = Objects.requireNonNull(value, "task is required");
            return this;
        }

        public Builder withComment(@Nullable String value) {
            this._comment = value;
            return this;
        }

        public Builder withInputPath(@Nullable String value) {
            this._inputPath = value;
            return this;
        }

        public Builder withOutputPath(@Nullable String value) {
            this._outputPath = value;
            return this;
        }

        public Builder withResultPath(@Nullable String value) {
            this._resultPath = value;
            return this;
        }

        public Builder withTimeoutSeconds(@Nullable Number value) {
            this._timeoutSeconds = value;
            return this;
        }

        public TaskProps build() {
            return new TaskProps(){
                private final IStepFunctionsTask $task;
                @Nullable
                private final String $comment;
                @Nullable
                private final String $inputPath;
                @Nullable
                private final String $outputPath;
                @Nullable
                private final String $resultPath;
                @Nullable
                private final Number $timeoutSeconds;
                {
                    this.$task = Objects.requireNonNull(_task, "task is required");
                    this.$comment = _comment;
                    this.$inputPath = _inputPath;
                    this.$outputPath = _outputPath;
                    this.$resultPath = _resultPath;
                    this.$timeoutSeconds = _timeoutSeconds;
                }

                @Override
                public IStepFunctionsTask getTask() {
                    return this.$task;
                }

                @Override
                public String getComment() {
                    return this.$comment;
                }

                @Override
                public String getInputPath() {
                    return this.$inputPath;
                }

                @Override
                public String getOutputPath() {
                    return this.$outputPath;
                }

                @Override
                public String getResultPath() {
                    return this.$resultPath;
                }

                @Override
                public Number getTimeoutSeconds() {
                    return this.$timeoutSeconds;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("task", om.valueToTree((Object)this.getTask()));
                    if (this.getComment() != null) {
                        obj.set("comment", om.valueToTree((Object)this.getComment()));
                    }
                    if (this.getInputPath() != null) {
                        obj.set("inputPath", om.valueToTree((Object)this.getInputPath()));
                    }
                    if (this.getOutputPath() != null) {
                        obj.set("outputPath", om.valueToTree((Object)this.getOutputPath()));
                    }
                    if (this.getResultPath() != null) {
                        obj.set("resultPath", om.valueToTree((Object)this.getResultPath()));
                    }
                    if (this.getTimeoutSeconds() != null) {
                        obj.set("timeoutSeconds", om.valueToTree((Object)this.getTimeoutSeconds()));
                    }
                    return obj;
                }
            };
        }
    }
}

