/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.List;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.tasks.CommonEcsRunTaskProps;
import software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride;
import software.amazon.jsii.JsiiSerializable;

public interface CommonEcsRunTaskProps
extends JsiiSerializable {
    public ICluster getCluster();

    public TaskDefinition getTaskDefinition();

    public List<ContainerOverride> getContainerOverrides();

    public ServiceIntegrationPattern getIntegrationPattern();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ICluster cluster;
        private TaskDefinition taskDefinition;
        private List<ContainerOverride> containerOverrides;
        private ServiceIntegrationPattern integrationPattern;

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder taskDefinition(TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public Builder containerOverrides(List<ContainerOverride> containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public Builder integrationPattern(ServiceIntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        public CommonEcsRunTaskProps build() {
            return new Jsii.Proxy(this.cluster, this.taskDefinition, this.containerOverrides, this.integrationPattern, null);
        }
    }
}

