/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.stepfunctions.IntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig;
import software.amazon.awscdk.services.stepfunctions.TaskStateBase;
import software.amazon.awscdk.services.stepfunctions.tasks.;
import software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride;
import software.amazon.awscdk.services.stepfunctions.tasks.EcsRunTaskProps;
import software.amazon.awscdk.services.stepfunctions.tasks.IEcsLaunchTarget;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EcsRunTask")
public class EcsRunTask
extends TaskStateBase
implements IConnectable {
    protected EcsRunTask(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsRunTask(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EcsRunTask(@NotNull Construct scope, @NotNull String id, @NotNull EcsRunTaskProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @Nullable
    protected TaskMetricsConfig getTaskMetrics() {
        return (TaskMetricsConfig)this.jsiiGet("taskMetrics", TaskMetricsConfig.class);
    }

    @Nullable
    protected List<PolicyStatement> getTaskPolicies() {
        return Optional.ofNullable((List)this.jsiiGet("taskPolicies", NativeType.listOf((NativeType)NativeType.forClass(PolicyStatement.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EcsRunTask> {
        private final Construct scope;
        private final String id;
        private final EcsRunTaskProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new EcsRunTaskProps.Builder();
        }

        public Builder comment(String comment) {
            this.props.comment(comment);
            return this;
        }

        public Builder heartbeat(Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        public Builder integrationPattern(IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        public Builder launchTarget(IEcsLaunchTarget launchTarget) {
            this.props.launchTarget(launchTarget);
            return this;
        }

        public Builder taskDefinition(TaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        public Builder assignPublicIp(Boolean assignPublicIp) {
            this.props.assignPublicIp(assignPublicIp);
            return this;
        }

        public Builder containerOverrides(List<? extends ContainerOverride> containerOverrides) {
            this.props.containerOverrides(containerOverrides);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder subnets(SubnetSelection subnets) {
            this.props.subnets(subnets);
            return this;
        }

        public EcsRunTask build() {
            return new EcsRunTask(this.scope, this.id, this.props.build());
        }
    }
}

