/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.List;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.ISubnet;
import software.amazon.awscdk.services.ec2.Vpc;
import software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig;
import software.amazon.jsii.JsiiSerializable;

public interface VpcConfig
extends JsiiSerializable {
    public List<ISecurityGroup> getSecurityGroups();

    public List<ISubnet> getSubnets();

    public Vpc getVpc();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ISecurityGroup> securityGroups;
        private List<ISubnet> subnets;
        private Vpc vpc;

        public Builder securityGroups(List<ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder subnets(List<ISubnet> subnets) {
            this.subnets = subnets;
            return this;
        }

        public Builder vpc(Vpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public VpcConfig build() {
            return new Jsii.Proxy(this.securityGroups, this.subnets, this.vpc, null);
        }
    }
}

