/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.kms.Key;
import software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface TransformOutput
extends JsiiSerializable {
    public String getS3OutputPath();

    public String getAccept();

    public AssembleWith getAssembleWith();

    public Key getEncryptionKey();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _s3OutputPath;
        @Nullable
        private String _accept;
        @Nullable
        private AssembleWith _assembleWith;
        @Nullable
        private Key _encryptionKey;

        public Builder withS3OutputPath(String value) {
            this._s3OutputPath = Objects.requireNonNull(value, "s3OutputPath is required");
            return this;
        }

        public Builder withAccept(@Nullable String value) {
            this._accept = value;
            return this;
        }

        public Builder withAssembleWith(@Nullable AssembleWith value) {
            this._assembleWith = value;
            return this;
        }

        public Builder withEncryptionKey(@Nullable Key value) {
            this._encryptionKey = value;
            return this;
        }

        public TransformOutput build() {
            return new TransformOutput(){
                private final String $s3OutputPath;
                @Nullable
                private final String $accept;
                @Nullable
                private final AssembleWith $assembleWith;
                @Nullable
                private final Key $encryptionKey;
                {
                    this.$s3OutputPath = Objects.requireNonNull(_s3OutputPath, "s3OutputPath is required");
                    this.$accept = _accept;
                    this.$assembleWith = _assembleWith;
                    this.$encryptionKey = _encryptionKey;
                }

                @Override
                public String getS3OutputPath() {
                    return this.$s3OutputPath;
                }

                @Override
                public String getAccept() {
                    return this.$accept;
                }

                @Override
                public AssembleWith getAssembleWith() {
                    return this.$assembleWith;
                }

                @Override
                public Key getEncryptionKey() {
                    return this.$encryptionKey;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("s3OutputPath", om.valueToTree((Object)this.getS3OutputPath()));
                    if (this.getAccept() != null) {
                        obj.set("accept", om.valueToTree((Object)this.getAccept()));
                    }
                    if (this.getAssembleWith() != null) {
                        obj.set("assembleWith", om.valueToTree((Object)this.getAssembleWith()));
                    }
                    if (this.getEncryptionKey() != null) {
                        obj.set("encryptionKey", om.valueToTree((Object)this.getEncryptionKey()));
                    }
                    return obj;
                }
            };
        }
    }
}

