/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PlacementConstraint;
import software.amazon.awscdk.services.ecs.PlacementStrategy;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.tasks.CommonEcsRunTaskProps;
import software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface RunEcsEc2TaskProps
extends JsiiSerializable,
CommonEcsRunTaskProps {
    public List<PlacementConstraint> getPlacementConstraints();

    public List<PlacementStrategy> getPlacementStrategies();

    public ISecurityGroup getSecurityGroup();

    public SubnetSelection getSubnets();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private List<PlacementConstraint> _placementConstraints;
        @Nullable
        private List<PlacementStrategy> _placementStrategies;
        @Nullable
        private ISecurityGroup _securityGroup;
        @Nullable
        private SubnetSelection _subnets;
        private ICluster _cluster;
        private TaskDefinition _taskDefinition;
        @Nullable
        private List<ContainerOverride> _containerOverrides;
        @Nullable
        private ServiceIntegrationPattern _integrationPattern;

        public Builder withPlacementConstraints(@Nullable List<PlacementConstraint> value) {
            this._placementConstraints = value;
            return this;
        }

        public Builder withPlacementStrategies(@Nullable List<PlacementStrategy> value) {
            this._placementStrategies = value;
            return this;
        }

        public Builder withSecurityGroup(@Nullable ISecurityGroup value) {
            this._securityGroup = value;
            return this;
        }

        public Builder withSubnets(@Nullable SubnetSelection value) {
            this._subnets = value;
            return this;
        }

        public Builder withCluster(ICluster value) {
            this._cluster = Objects.requireNonNull(value, "cluster is required");
            return this;
        }

        public Builder withTaskDefinition(TaskDefinition value) {
            this._taskDefinition = Objects.requireNonNull(value, "taskDefinition is required");
            return this;
        }

        public Builder withContainerOverrides(@Nullable List<ContainerOverride> value) {
            this._containerOverrides = value;
            return this;
        }

        public Builder withIntegrationPattern(@Nullable ServiceIntegrationPattern value) {
            this._integrationPattern = value;
            return this;
        }

        public RunEcsEc2TaskProps build() {
            return new RunEcsEc2TaskProps(){
                @Nullable
                private final List<PlacementConstraint> $placementConstraints;
                @Nullable
                private final List<PlacementStrategy> $placementStrategies;
                @Nullable
                private final ISecurityGroup $securityGroup;
                @Nullable
                private final SubnetSelection $subnets;
                private final ICluster $cluster;
                private final TaskDefinition $taskDefinition;
                @Nullable
                private final List<ContainerOverride> $containerOverrides;
                @Nullable
                private final ServiceIntegrationPattern $integrationPattern;
                {
                    this.$placementConstraints = _placementConstraints;
                    this.$placementStrategies = _placementStrategies;
                    this.$securityGroup = _securityGroup;
                    this.$subnets = _subnets;
                    this.$cluster = Objects.requireNonNull(_cluster, "cluster is required");
                    this.$taskDefinition = Objects.requireNonNull(_taskDefinition, "taskDefinition is required");
                    this.$containerOverrides = _containerOverrides;
                    this.$integrationPattern = _integrationPattern;
                }

                @Override
                public List<PlacementConstraint> getPlacementConstraints() {
                    return this.$placementConstraints;
                }

                @Override
                public List<PlacementStrategy> getPlacementStrategies() {
                    return this.$placementStrategies;
                }

                @Override
                public ISecurityGroup getSecurityGroup() {
                    return this.$securityGroup;
                }

                @Override
                public SubnetSelection getSubnets() {
                    return this.$subnets;
                }

                @Override
                public ICluster getCluster() {
                    return this.$cluster;
                }

                @Override
                public TaskDefinition getTaskDefinition() {
                    return this.$taskDefinition;
                }

                @Override
                public List<ContainerOverride> getContainerOverrides() {
                    return this.$containerOverrides;
                }

                @Override
                public ServiceIntegrationPattern getIntegrationPattern() {
                    return this.$integrationPattern;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    if (this.getPlacementConstraints() != null) {
                        obj.set("placementConstraints", om.valueToTree(this.getPlacementConstraints()));
                    }
                    if (this.getPlacementStrategies() != null) {
                        obj.set("placementStrategies", om.valueToTree(this.getPlacementStrategies()));
                    }
                    if (this.getSecurityGroup() != null) {
                        obj.set("securityGroup", om.valueToTree((Object)this.getSecurityGroup()));
                    }
                    if (this.getSubnets() != null) {
                        obj.set("subnets", om.valueToTree((Object)this.getSubnets()));
                    }
                    obj.set("cluster", om.valueToTree((Object)this.getCluster()));
                    obj.set("taskDefinition", om.valueToTree((Object)this.getTaskDefinition()));
                    if (this.getContainerOverrides() != null) {
                        obj.set("containerOverrides", om.valueToTree(this.getContainerOverrides()));
                    }
                    if (this.getIntegrationPattern() != null) {
                        obj.set("integrationPattern", om.valueToTree((Object)this.getIntegrationPattern()));
                    }
                    return obj;
                }
            };
        }
    }
}

