/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.tasks.CommonEcsRunTaskProps;
import software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface EcsRunTaskBaseProps
extends JsiiSerializable,
CommonEcsRunTaskProps {
    public Map<String, Object> getParameters();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Map<String, Object> _parameters;
        private ICluster _cluster;
        private TaskDefinition _taskDefinition;
        @Nullable
        private List<ContainerOverride> _containerOverrides;
        @Nullable
        private ServiceIntegrationPattern _integrationPattern;

        public Builder withParameters(@Nullable Map<String, Object> value) {
            this._parameters = value;
            return this;
        }

        public Builder withCluster(ICluster value) {
            this._cluster = Objects.requireNonNull(value, "cluster is required");
            return this;
        }

        public Builder withTaskDefinition(TaskDefinition value) {
            this._taskDefinition = Objects.requireNonNull(value, "taskDefinition is required");
            return this;
        }

        public Builder withContainerOverrides(@Nullable List<ContainerOverride> value) {
            this._containerOverrides = value;
            return this;
        }

        public Builder withIntegrationPattern(@Nullable ServiceIntegrationPattern value) {
            this._integrationPattern = value;
            return this;
        }

        public EcsRunTaskBaseProps build() {
            return new EcsRunTaskBaseProps(){
                @Nullable
                private final Map<String, Object> $parameters;
                private final ICluster $cluster;
                private final TaskDefinition $taskDefinition;
                @Nullable
                private final List<ContainerOverride> $containerOverrides;
                @Nullable
                private final ServiceIntegrationPattern $integrationPattern;
                {
                    this.$parameters = _parameters;
                    this.$cluster = Objects.requireNonNull(_cluster, "cluster is required");
                    this.$taskDefinition = Objects.requireNonNull(_taskDefinition, "taskDefinition is required");
                    this.$containerOverrides = _containerOverrides;
                    this.$integrationPattern = _integrationPattern;
                }

                @Override
                public Map<String, Object> getParameters() {
                    return this.$parameters;
                }

                @Override
                public ICluster getCluster() {
                    return this.$cluster;
                }

                @Override
                public TaskDefinition getTaskDefinition() {
                    return this.$taskDefinition;
                }

                @Override
                public List<ContainerOverride> getContainerOverrides() {
                    return this.$containerOverrides;
                }

                @Override
                public ServiceIntegrationPattern getIntegrationPattern() {
                    return this.$integrationPattern;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    if (this.getParameters() != null) {
                        obj.set("parameters", om.valueToTree(this.getParameters()));
                    }
                    obj.set("cluster", om.valueToTree((Object)this.getCluster()));
                    obj.set("taskDefinition", om.valueToTree((Object)this.getTaskDefinition()));
                    if (this.getContainerOverrides() != null) {
                        obj.set("containerOverrides", om.valueToTree(this.getContainerOverrides()));
                    }
                    if (this.getIntegrationPattern() != null) {
                        obj.set("integrationPattern", om.valueToTree((Object)this.getIntegrationPattern()));
                    }
                    return obj;
                }
            };
        }
    }
}

