/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask;
import software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig;
import software.amazon.awscdk.services.stepfunctions.Task;
import software.amazon.awscdk.services.stepfunctions.tasks.$Module;
import software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster;
import software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateClusterProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster")
public class EmrCreateCluster
extends JsiiObject
implements IStepFunctionsTask {
    protected EmrCreateCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmrCreateCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EmrCreateCluster(@NotNull EmrCreateClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public StepFunctionsTaskConfig bind(@NotNull Task task) {
        return (StepFunctionsTaskConfig)this.jsiiCall("bind", StepFunctionsTaskConfig.class, new Object[]{Objects.requireNonNull(task, "task is required")});
    }

    @NotNull
    public IRole getAutoScalingRole() {
        return (IRole)this.jsiiGet("autoScalingRole", IRole.class);
    }

    @NotNull
    public IRole getClusterRole() {
        return (IRole)this.jsiiGet("clusterRole", IRole.class);
    }

    @NotNull
    public IRole getServiceRole() {
        return (IRole)this.jsiiGet("serviceRole", IRole.class);
    }

    public static final class Builder {
        private final EmrCreateClusterProps.Builder props = new EmrCreateClusterProps.Builder();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder instances(InstancesConfigProperty instances) {
            this.props.instances(instances);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder additionalInfo(String additionalInfo) {
            this.props.additionalInfo(additionalInfo);
            return this;
        }

        public Builder applications(List<ApplicationConfigProperty> applications) {
            this.props.applications(applications);
            return this;
        }

        public Builder autoScalingRole(IRole autoScalingRole) {
            this.props.autoScalingRole(autoScalingRole);
            return this;
        }

        public Builder bootstrapActions(List<BootstrapActionConfigProperty> bootstrapActions) {
            this.props.bootstrapActions(bootstrapActions);
            return this;
        }

        public Builder clusterRole(IRole clusterRole) {
            this.props.clusterRole(clusterRole);
            return this;
        }

        public Builder configurations(List<ConfigurationProperty> configurations) {
            this.props.configurations(configurations);
            return this;
        }

        public Builder customAmiId(String customAmiId) {
            this.props.customAmiId(customAmiId);
            return this;
        }

        public Builder ebsRootVolumeSize(Number ebsRootVolumeSize) {
            this.props.ebsRootVolumeSize(ebsRootVolumeSize);
            return this;
        }

        public Builder integrationPattern(ServiceIntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        public Builder kerberosAttributes(KerberosAttributesProperty kerberosAttributes) {
            this.props.kerberosAttributes(kerberosAttributes);
            return this;
        }

        public Builder logUri(String logUri) {
            this.props.logUri(logUri);
            return this;
        }

        public Builder releaseLabel(String releaseLabel) {
            this.props.releaseLabel(releaseLabel);
            return this;
        }

        public Builder scaleDownBehavior(EmrClusterScaleDownBehavior scaleDownBehavior) {
            this.props.scaleDownBehavior(scaleDownBehavior);
            return this;
        }

        public Builder securityConfiguration(String securityConfiguration) {
            this.props.securityConfiguration(securityConfiguration);
            return this;
        }

        public Builder serviceRole(IRole serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder visibleToAllUsers(Boolean visibleToAllUsers) {
            this.props.visibleToAllUsers(visibleToAllUsers);
            return this;
        }

        public EmrCreateCluster build() {
            return new EmrCreateCluster(this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.VolumeSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VolumeSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getSizeInGb();

        @NotNull
        public EbsBlockDeviceVolumeType getVolumeType();

        @Nullable
        default public Number getIops() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number sizeInGb;
            private EbsBlockDeviceVolumeType volumeType;
            private Number iops;

            public Builder sizeInGb(Number sizeInGb) {
                this.sizeInGb = sizeInGb;
                return this;
            }

            public Builder volumeType(EbsBlockDeviceVolumeType volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public VolumeSpecificationProperty build() {
                return new Jsii.Proxy(this.sizeInGb, this.volumeType, this.iops, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.SpotTimeoutAction")
    public static enum SpotTimeoutAction {
        SWITCH_TO_ON_DEMAND,
        TERMINATE_CLUSTER;

    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpotProvisioningSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public SpotTimeoutAction getTimeoutAction();

        @NotNull
        public Number getTimeoutDurationMinutes();

        @Nullable
        default public Number getBlockDurationMinutes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private SpotTimeoutAction timeoutAction;
            private Number timeoutDurationMinutes;
            private Number blockDurationMinutes;

            public Builder timeoutAction(SpotTimeoutAction timeoutAction) {
                this.timeoutAction = timeoutAction;
                return this;
            }

            public Builder timeoutDurationMinutes(Number timeoutDurationMinutes) {
                this.timeoutDurationMinutes = timeoutDurationMinutes;
                return this;
            }

            public Builder blockDurationMinutes(Number blockDurationMinutes) {
                this.blockDurationMinutes = blockDurationMinutes;
                return this;
            }

            public SpotProvisioningSpecificationProperty build() {
                return new Jsii.Proxy(this.timeoutAction, this.timeoutDurationMinutes, this.blockDurationMinutes, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SimpleScalingPolicyConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getScalingAdjustment();

        @Nullable
        default public ScalingAdjustmentType getAdjustmentType() {
            return null;
        }

        @Nullable
        default public Number getCoolDown() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number scalingAdjustment;
            private ScalingAdjustmentType adjustmentType;
            private Number coolDown;

            public Builder scalingAdjustment(Number scalingAdjustment) {
                this.scalingAdjustment = scalingAdjustment;
                return this;
            }

            public Builder adjustmentType(ScalingAdjustmentType adjustmentType) {
                this.adjustmentType = adjustmentType;
                return this;
            }

            public Builder coolDown(Number coolDown) {
                this.coolDown = coolDown;
                return this;
            }

            public SimpleScalingPolicyConfigurationProperty build() {
                return new Jsii.Proxy(this.scalingAdjustment, this.adjustmentType, this.coolDown, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScriptBootstrapActionConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getPath();

        @Nullable
        default public List<String> getArgs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String path;
            private List<String> args;

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder args(List<String> args) {
                this.args = args;
                return this;
            }

            public ScriptBootstrapActionConfigProperty build() {
                return new Jsii.Proxy(this.path, this.args, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScalingTriggerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingTriggerProperty
    extends JsiiSerializable {
        @NotNull
        public CloudWatchAlarmDefinitionProperty getCloudWatchAlarmDefinition();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinition;

            public Builder cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinition) {
                this.cloudWatchAlarmDefinition = cloudWatchAlarmDefinition;
                return this;
            }

            public ScalingTriggerProperty build() {
                return new Jsii.Proxy(this.cloudWatchAlarmDefinition, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScalingRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingRuleProperty
    extends JsiiSerializable {
        @NotNull
        public ScalingActionProperty getAction();

        @NotNull
        public String getName();

        @NotNull
        public ScalingTriggerProperty getTrigger();

        @Nullable
        default public String getDescription() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private ScalingActionProperty action;
            private String name;
            private ScalingTriggerProperty trigger;
            private String description;

            public Builder action(ScalingActionProperty action) {
                this.action = action;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder trigger(ScalingTriggerProperty trigger) {
                this.trigger = trigger;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public ScalingRuleProperty build() {
                return new Jsii.Proxy(this.action, this.name, this.trigger, this.description, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScalingConstraintsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingConstraintsProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxCapacity();

        @NotNull
        public Number getMinCapacity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number maxCapacity;
            private Number minCapacity;

            public Builder maxCapacity(Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            public Builder minCapacity(Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            public ScalingConstraintsProperty build() {
                return new Jsii.Proxy(this.maxCapacity, this.minCapacity, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScalingAdjustmentType")
    public static enum ScalingAdjustmentType {
        CHANGE_IN_CAPACITY,
        PERCENT_CHANGE_IN_CAPACITY,
        EXACT_CAPACITY;

    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScalingActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingActionProperty
    extends JsiiSerializable {
        @NotNull
        public SimpleScalingPolicyConfigurationProperty getSimpleScalingPolicyConfiguration();

        @Nullable
        default public InstanceMarket getMarket() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfiguration;
            private InstanceMarket market;

            public Builder simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfiguration) {
                this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
                return this;
            }

            public Builder market(InstanceMarket market) {
                this.market = market;
                return this;
            }

            public ScalingActionProperty build() {
                return new Jsii.Proxy(this.simpleScalingPolicyConfiguration, this.market, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.PlacementTypeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PlacementTypeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAvailabilityZone() {
            return null;
        }

        @Nullable
        default public List<String> getAvailabilityZones() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String availabilityZone;
            private List<String> availabilityZones;

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder availabilityZones(List<String> availabilityZones) {
                this.availabilityZones = availabilityZones;
                return this;
            }

            public PlacementTypeProperty build() {
                return new Jsii.Proxy(this.availabilityZone, this.availabilityZones, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.MetricDimensionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricDimensionProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public MetricDimensionProperty build() {
                return new Jsii.Proxy(this.key, this.value, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.KerberosAttributesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KerberosAttributesProperty
    extends JsiiSerializable {
        @NotNull
        public String getRealm();

        @Nullable
        default public String getAdDomainJoinPassword() {
            return null;
        }

        @Nullable
        default public String getAdDomainJoinUser() {
            return null;
        }

        @Nullable
        default public String getCrossRealmTrustPrincipalPassword() {
            return null;
        }

        @Nullable
        default public String getKdcAdminPassword() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String realm;
            private String adDomainJoinPassword;
            private String adDomainJoinUser;
            private String crossRealmTrustPrincipalPassword;
            private String kdcAdminPassword;

            public Builder realm(String realm) {
                this.realm = realm;
                return this;
            }

            public Builder adDomainJoinPassword(String adDomainJoinPassword) {
                this.adDomainJoinPassword = adDomainJoinPassword;
                return this;
            }

            public Builder adDomainJoinUser(String adDomainJoinUser) {
                this.adDomainJoinUser = adDomainJoinUser;
                return this;
            }

            public Builder crossRealmTrustPrincipalPassword(String crossRealmTrustPrincipalPassword) {
                this.crossRealmTrustPrincipalPassword = crossRealmTrustPrincipalPassword;
                return this;
            }

            public Builder kdcAdminPassword(String kdcAdminPassword) {
                this.kdcAdminPassword = kdcAdminPassword;
                return this;
            }

            public KerberosAttributesProperty build() {
                return new Jsii.Proxy(this.realm, this.adDomainJoinPassword, this.adDomainJoinUser, this.crossRealmTrustPrincipalPassword, this.kdcAdminPassword, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstancesConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstancesConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAdditionalMasterSecurityGroups() {
            return null;
        }

        @Nullable
        default public List<String> getAdditionalSlaveSecurityGroups() {
            return null;
        }

        @Nullable
        default public String getEc2KeyName() {
            return null;
        }

        @Nullable
        default public String getEc2SubnetId() {
            return null;
        }

        @Nullable
        default public List<String> getEc2SubnetIds() {
            return null;
        }

        @Nullable
        default public String getEmrManagedMasterSecurityGroup() {
            return null;
        }

        @Nullable
        default public String getEmrManagedSlaveSecurityGroup() {
            return null;
        }

        @Nullable
        default public String getHadoopVersion() {
            return null;
        }

        @Nullable
        default public Number getInstanceCount() {
            return null;
        }

        @Nullable
        default public List<InstanceFleetConfigProperty> getInstanceFleets() {
            return null;
        }

        @Nullable
        default public List<InstanceGroupConfigProperty> getInstanceGroups() {
            return null;
        }

        @Nullable
        default public String getMasterInstanceType() {
            return null;
        }

        @Nullable
        default public PlacementTypeProperty getPlacement() {
            return null;
        }

        @Nullable
        default public String getServiceAccessSecurityGroup() {
            return null;
        }

        @Nullable
        default public String getSlaveInstanceType() {
            return null;
        }

        @Nullable
        default public Boolean getTerminationProtected() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> additionalMasterSecurityGroups;
            private List<String> additionalSlaveSecurityGroups;
            private String ec2KeyName;
            private String ec2SubnetId;
            private List<String> ec2SubnetIds;
            private String emrManagedMasterSecurityGroup;
            private String emrManagedSlaveSecurityGroup;
            private String hadoopVersion;
            private Number instanceCount;
            private List<InstanceFleetConfigProperty> instanceFleets;
            private List<InstanceGroupConfigProperty> instanceGroups;
            private String masterInstanceType;
            private PlacementTypeProperty placement;
            private String serviceAccessSecurityGroup;
            private String slaveInstanceType;
            private Boolean terminationProtected;

            public Builder additionalMasterSecurityGroups(List<String> additionalMasterSecurityGroups) {
                this.additionalMasterSecurityGroups = additionalMasterSecurityGroups;
                return this;
            }

            public Builder additionalSlaveSecurityGroups(List<String> additionalSlaveSecurityGroups) {
                this.additionalSlaveSecurityGroups = additionalSlaveSecurityGroups;
                return this;
            }

            public Builder ec2KeyName(String ec2KeyName) {
                this.ec2KeyName = ec2KeyName;
                return this;
            }

            public Builder ec2SubnetId(String ec2SubnetId) {
                this.ec2SubnetId = ec2SubnetId;
                return this;
            }

            public Builder ec2SubnetIds(List<String> ec2SubnetIds) {
                this.ec2SubnetIds = ec2SubnetIds;
                return this;
            }

            public Builder emrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
                this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
                return this;
            }

            public Builder emrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
                this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
                return this;
            }

            public Builder hadoopVersion(String hadoopVersion) {
                this.hadoopVersion = hadoopVersion;
                return this;
            }

            public Builder instanceCount(Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            public Builder instanceFleets(List<InstanceFleetConfigProperty> instanceFleets) {
                this.instanceFleets = instanceFleets;
                return this;
            }

            public Builder instanceGroups(List<InstanceGroupConfigProperty> instanceGroups) {
                this.instanceGroups = instanceGroups;
                return this;
            }

            public Builder masterInstanceType(String masterInstanceType) {
                this.masterInstanceType = masterInstanceType;
                return this;
            }

            public Builder placement(PlacementTypeProperty placement) {
                this.placement = placement;
                return this;
            }

            public Builder serviceAccessSecurityGroup(String serviceAccessSecurityGroup) {
                this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
                return this;
            }

            public Builder slaveInstanceType(String slaveInstanceType) {
                this.slaveInstanceType = slaveInstanceType;
                return this;
            }

            public Builder terminationProtected(Boolean terminationProtected) {
                this.terminationProtected = terminationProtected;
                return this;
            }

            public InstancesConfigProperty build() {
                return new Jsii.Proxy(this.additionalMasterSecurityGroups, this.additionalSlaveSecurityGroups, this.ec2KeyName, this.ec2SubnetId, this.ec2SubnetIds, this.emrManagedMasterSecurityGroup, this.emrManagedSlaveSecurityGroup, this.hadoopVersion, this.instanceCount, this.instanceFleets, this.instanceGroups, this.masterInstanceType, this.placement, this.serviceAccessSecurityGroup, this.slaveInstanceType, this.terminationProtected, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceTypeConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceTypeConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getInstanceType();

        @Nullable
        default public String getBidPrice() {
            return null;
        }

        @Nullable
        default public Number getBidPriceAsPercentageOfOnDemandPrice() {
            return null;
        }

        @Nullable
        default public List<ConfigurationProperty> getConfigurations() {
            return null;
        }

        @Nullable
        default public EbsConfigurationProperty getEbsConfiguration() {
            return null;
        }

        @Nullable
        default public Number getWeightedCapacity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String instanceType;
            private String bidPrice;
            private Number bidPriceAsPercentageOfOnDemandPrice;
            private List<ConfigurationProperty> configurations;
            private EbsConfigurationProperty ebsConfiguration;
            private Number weightedCapacity;

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder bidPrice(String bidPrice) {
                this.bidPrice = bidPrice;
                return this;
            }

            public Builder bidPriceAsPercentageOfOnDemandPrice(Number bidPriceAsPercentageOfOnDemandPrice) {
                this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
                return this;
            }

            public Builder configurations(List<ConfigurationProperty> configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder ebsConfiguration(EbsConfigurationProperty ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            public Builder weightedCapacity(Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            public InstanceTypeConfigProperty build() {
                return new Jsii.Proxy(this.instanceType, this.bidPrice, this.bidPriceAsPercentageOfOnDemandPrice, this.configurations, this.ebsConfiguration, this.weightedCapacity, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceRoleType")
    public static enum InstanceRoleType {
        MASTER,
        CORE,
        TASK;

    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceMarket")
    public static enum InstanceMarket {
        ON_DEMAND,
        SPOT;

    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceGroupConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceGroupConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Number getInstanceCount();

        @NotNull
        public InstanceRoleType getInstanceRole();

        @NotNull
        public String getInstanceType();

        @Nullable
        default public AutoScalingPolicyProperty getAutoScalingPolicy() {
            return null;
        }

        @Nullable
        default public String getBidPrice() {
            return null;
        }

        @Nullable
        default public List<ConfigurationProperty> getConfigurations() {
            return null;
        }

        @Nullable
        default public EbsConfigurationProperty getEbsConfiguration() {
            return null;
        }

        @Nullable
        default public InstanceMarket getMarket() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number instanceCount;
            private InstanceRoleType instanceRole;
            private String instanceType;
            private AutoScalingPolicyProperty autoScalingPolicy;
            private String bidPrice;
            private List<ConfigurationProperty> configurations;
            private EbsConfigurationProperty ebsConfiguration;
            private InstanceMarket market;
            private String name;

            public Builder instanceCount(Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            public Builder instanceRole(InstanceRoleType instanceRole) {
                this.instanceRole = instanceRole;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder autoScalingPolicy(AutoScalingPolicyProperty autoScalingPolicy) {
                this.autoScalingPolicy = autoScalingPolicy;
                return this;
            }

            public Builder bidPrice(String bidPrice) {
                this.bidPrice = bidPrice;
                return this;
            }

            public Builder configurations(List<ConfigurationProperty> configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder ebsConfiguration(EbsConfigurationProperty ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            public Builder market(InstanceMarket market) {
                this.market = market;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public InstanceGroupConfigProperty build() {
                return new Jsii.Proxy(this.instanceCount, this.instanceRole, this.instanceType, this.autoScalingPolicy, this.bidPrice, this.configurations, this.ebsConfiguration, this.market, this.name, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceFleetProvisioningSpecificationsProperty
    extends JsiiSerializable {
        @NotNull
        public SpotProvisioningSpecificationProperty getSpotSpecification();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private SpotProvisioningSpecificationProperty spotSpecification;

            public Builder spotSpecification(SpotProvisioningSpecificationProperty spotSpecification) {
                this.spotSpecification = spotSpecification;
                return this;
            }

            public InstanceFleetProvisioningSpecificationsProperty build() {
                return new Jsii.Proxy(this.spotSpecification, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceFleetConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceFleetConfigProperty
    extends JsiiSerializable {
        @NotNull
        public InstanceRoleType getInstanceFleetType();

        @Nullable
        default public List<InstanceTypeConfigProperty> getInstanceTypeConfigs() {
            return null;
        }

        @Nullable
        default public InstanceFleetProvisioningSpecificationsProperty getLaunchSpecifications() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Number getTargetOnDemandCapacity() {
            return null;
        }

        @Nullable
        default public Number getTargetSpotCapacity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private InstanceRoleType instanceFleetType;
            private List<InstanceTypeConfigProperty> instanceTypeConfigs;
            private InstanceFleetProvisioningSpecificationsProperty launchSpecifications;
            private String name;
            private Number targetOnDemandCapacity;
            private Number targetSpotCapacity;

            public Builder instanceFleetType(InstanceRoleType instanceFleetType) {
                this.instanceFleetType = instanceFleetType;
                return this;
            }

            public Builder instanceTypeConfigs(List<InstanceTypeConfigProperty> instanceTypeConfigs) {
                this.instanceTypeConfigs = instanceTypeConfigs;
                return this;
            }

            public Builder launchSpecifications(InstanceFleetProvisioningSpecificationsProperty launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder targetOnDemandCapacity(Number targetOnDemandCapacity) {
                this.targetOnDemandCapacity = targetOnDemandCapacity;
                return this;
            }

            public Builder targetSpotCapacity(Number targetSpotCapacity) {
                this.targetSpotCapacity = targetSpotCapacity;
                return this;
            }

            public InstanceFleetConfigProperty build() {
                return new Jsii.Proxy(this.instanceFleetType, this.instanceTypeConfigs, this.launchSpecifications, this.name, this.targetOnDemandCapacity, this.targetSpotCapacity, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.EmrClusterScaleDownBehavior")
    public static enum EmrClusterScaleDownBehavior {
        TERMINATE_AT_INSTANCE_HOUR,
        TERMINATE_AT_TASK_COMPLETION;

    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.EbsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public List<EbsBlockDeviceConfigProperty> getEbsBlockDeviceConfigs() {
            return null;
        }

        @Nullable
        default public Boolean getEbsOptimized() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<EbsBlockDeviceConfigProperty> ebsBlockDeviceConfigs;
            private Boolean ebsOptimized;

            public Builder ebsBlockDeviceConfigs(List<EbsBlockDeviceConfigProperty> ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = ebsBlockDeviceConfigs;
                return this;
            }

            public Builder ebsOptimized(Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public EbsConfigurationProperty build() {
                return new Jsii.Proxy(this.ebsBlockDeviceConfigs, this.ebsOptimized, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.EbsBlockDeviceVolumeType")
    public static enum EbsBlockDeviceVolumeType {
        GP2,
        IO1,
        STANDARD;

    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsBlockDeviceConfigProperty
    extends JsiiSerializable {
        @NotNull
        public VolumeSpecificationProperty getVolumeSpecification();

        @Nullable
        default public Number getVolumesPerInstance() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private VolumeSpecificationProperty volumeSpecification;
            private Number volumesPerInstance;

            public Builder volumeSpecification(VolumeSpecificationProperty volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            public Builder volumesPerInstance(Number volumesPerInstance) {
                this.volumesPerInstance = volumesPerInstance;
                return this;
            }

            public EbsBlockDeviceConfigProperty build() {
                return new Jsii.Proxy(this.volumeSpecification, this.volumesPerInstance, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getClassification() {
            return null;
        }

        @Nullable
        default public List<ConfigurationProperty> getConfigurations() {
            return null;
        }

        @Nullable
        default public Map<String, String> getProperties() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String classification;
            private List<ConfigurationProperty> configurations;
            private Map<String, String> properties;

            public Builder classification(String classification) {
                this.classification = classification;
                return this;
            }

            public Builder configurations(List<ConfigurationProperty> configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder properties(Map<String, String> properties) {
                this.properties = properties;
                return this;
            }

            public ConfigurationProperty build() {
                return new Jsii.Proxy(this.classification, this.configurations, this.properties, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.CloudWatchAlarmUnit")
    public static enum CloudWatchAlarmUnit {
        NONE,
        SECONDS,
        MICRO_SECONDS,
        MILLI_SECONDS,
        BYTES,
        KILO_BYTES,
        MEGA_BYTES,
        GIGA_BYTES,
        TERA_BYTES,
        BITS,
        KILO_BITS,
        MEGA_BITS,
        GIGA_BITS,
        TERA_BITS,
        PERCENT,
        COUNT,
        BYTES_PER_SECOND,
        KILO_BYTES_PER_SECOND,
        MEGA_BYTES_PER_SECOND,
        GIGA_BYTES_PER_SECOND,
        TERA_BYTES_PER_SECOND,
        BITS_PER_SECOND,
        KILO_BITS_PER_SECOND,
        MEGA_BITS_PER_SECOND,
        GIGA_BITS_PER_SECOND,
        TERA_BITS_PER_SECOND,
        COUNT_PER_SECOND;

    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.CloudWatchAlarmStatistic")
    public static enum CloudWatchAlarmStatistic {
        SAMPLE_COUNT,
        AVERAGE,
        SUM,
        MINIMUM,
        MAXIMUM;

    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchAlarmDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public CloudWatchAlarmComparisonOperator getComparisonOperator();

        @NotNull
        public String getMetricName();

        @NotNull
        public Duration getPeriod();

        @Nullable
        default public List<MetricDimensionProperty> getDimensions() {
            return null;
        }

        @Nullable
        default public Number getEvalutionPeriods() {
            return null;
        }

        @Nullable
        default public String getNamespace() {
            return null;
        }

        @Nullable
        default public CloudWatchAlarmStatistic getStatistic() {
            return null;
        }

        @Nullable
        default public Number getThreshold() {
            return null;
        }

        @Nullable
        default public CloudWatchAlarmUnit getUnit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private CloudWatchAlarmComparisonOperator comparisonOperator;
            private String metricName;
            private Duration period;
            private List<MetricDimensionProperty> dimensions;
            private Number evalutionPeriods;
            private String namespace;
            private CloudWatchAlarmStatistic statistic;
            private Number threshold;
            private CloudWatchAlarmUnit unit;

            public Builder comparisonOperator(CloudWatchAlarmComparisonOperator comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            public Builder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            public Builder period(Duration period) {
                this.period = period;
                return this;
            }

            public Builder dimensions(List<MetricDimensionProperty> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder evalutionPeriods(Number evalutionPeriods) {
                this.evalutionPeriods = evalutionPeriods;
                return this;
            }

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public Builder statistic(CloudWatchAlarmStatistic statistic) {
                this.statistic = statistic;
                return this;
            }

            public Builder threshold(Number threshold) {
                this.threshold = threshold;
                return this;
            }

            public Builder unit(CloudWatchAlarmUnit unit) {
                this.unit = unit;
                return this;
            }

            public CloudWatchAlarmDefinitionProperty build() {
                return new Jsii.Proxy(this.comparisonOperator, this.metricName, this.period, this.dimensions, this.evalutionPeriods, this.namespace, this.statistic, this.threshold, this.unit, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator")
    public static enum CloudWatchAlarmComparisonOperator {
        GREATER_THAN_OR_EQUAL,
        GREATER_THAN,
        LESS_THAN,
        LESS_THAN_OR_EQUAL;

    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.BootstrapActionConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BootstrapActionConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public ScriptBootstrapActionConfigProperty getScriptBootstrapAction();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String name;
            private ScriptBootstrapActionConfigProperty scriptBootstrapAction;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder scriptBootstrapAction(ScriptBootstrapActionConfigProperty scriptBootstrapAction) {
                this.scriptBootstrapAction = scriptBootstrapAction;
                return this;
            }

            public BootstrapActionConfigProperty build() {
                return new Jsii.Proxy(this.name, this.scriptBootstrapAction, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.AutoScalingPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoScalingPolicyProperty
    extends JsiiSerializable {
        @NotNull
        public ScalingConstraintsProperty getConstraints();

        @NotNull
        public List<ScalingRuleProperty> getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private ScalingConstraintsProperty constraints;
            private List<ScalingRuleProperty> rules;

            public Builder constraints(ScalingConstraintsProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            public Builder rules(List<ScalingRuleProperty> rules) {
                this.rules = rules;
                return this;
            }

            public AutoScalingPolicyProperty build() {
                return new Jsii.Proxy(this.constraints, this.rules, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ApplicationConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApplicationConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @Nullable
        default public Map<String, String> getAdditionalInfo() {
            return null;
        }

        @Nullable
        default public List<String> getArgs() {
            return null;
        }

        @Nullable
        default public String getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String name;
            private Map<String, String> additionalInfo;
            private List<String> args;
            private String version;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder additionalInfo(Map<String, String> additionalInfo) {
                this.additionalInfo = additionalInfo;
                return this;
            }

            public Builder args(List<String> args) {
                this.args = args;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public ApplicationConfigProperty build() {
                return new Jsii.Proxy(this.name, this.additionalInfo, this.args, this.version, null);
            }
        }
    }
}

