/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.stepfunctions.tasks.S3DataType;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface TransformS3DataSource
extends JsiiSerializable {
    public String getS3Uri();

    public S3DataType getS3DataType();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _s3Uri;
        @Nullable
        private S3DataType _s3DataType;

        public Builder withS3Uri(String value) {
            this._s3Uri = Objects.requireNonNull(value, "s3Uri is required");
            return this;
        }

        public Builder withS3DataType(@Nullable S3DataType value) {
            this._s3DataType = value;
            return this;
        }

        public TransformS3DataSource build() {
            return new TransformS3DataSource(){
                private final String $s3Uri;
                @Nullable
                private final S3DataType $s3DataType;
                {
                    this.$s3Uri = Objects.requireNonNull(_s3Uri, "s3Uri is required");
                    this.$s3DataType = _s3DataType;
                }

                @Override
                public String getS3Uri() {
                    return this.$s3Uri;
                }

                @Override
                public S3DataType getS3DataType() {
                    return this.$s3DataType;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("s3Uri", om.valueToTree((Object)this.getS3Uri()));
                    if (this.getS3DataType() != null) {
                        obj.set("s3DataType", om.valueToTree((Object)this.getS3DataType()));
                    }
                    return obj;
                }
            };
        }
    }
}

