/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.stepfunctions.tasks.CompressionType;
import software.amazon.awscdk.services.stepfunctions.tasks.SplitType;
import software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface TransformInput
extends JsiiSerializable {
    public TransformDataSource getTransformDataSource();

    public CompressionType getCompressionType();

    public String getContentType();

    public SplitType getSplitType();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TransformDataSource _transformDataSource;
        @Nullable
        private CompressionType _compressionType;
        @Nullable
        private String _contentType;
        @Nullable
        private SplitType _splitType;

        public Builder withTransformDataSource(TransformDataSource value) {
            this._transformDataSource = Objects.requireNonNull(value, "transformDataSource is required");
            return this;
        }

        public Builder withCompressionType(@Nullable CompressionType value) {
            this._compressionType = value;
            return this;
        }

        public Builder withContentType(@Nullable String value) {
            this._contentType = value;
            return this;
        }

        public Builder withSplitType(@Nullable SplitType value) {
            this._splitType = value;
            return this;
        }

        public TransformInput build() {
            return new TransformInput(){
                private final TransformDataSource $transformDataSource;
                @Nullable
                private final CompressionType $compressionType;
                @Nullable
                private final String $contentType;
                @Nullable
                private final SplitType $splitType;
                {
                    this.$transformDataSource = Objects.requireNonNull(_transformDataSource, "transformDataSource is required");
                    this.$compressionType = _compressionType;
                    this.$contentType = _contentType;
                    this.$splitType = _splitType;
                }

                @Override
                public TransformDataSource getTransformDataSource() {
                    return this.$transformDataSource;
                }

                @Override
                public CompressionType getCompressionType() {
                    return this.$compressionType;
                }

                @Override
                public String getContentType() {
                    return this.$contentType;
                }

                @Override
                public SplitType getSplitType() {
                    return this.$splitType;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("transformDataSource", om.valueToTree((Object)this.getTransformDataSource()));
                    if (this.getCompressionType() != null) {
                        obj.set("compressionType", om.valueToTree((Object)this.getCompressionType()));
                    }
                    if (this.getContentType() != null) {
                        obj.set("contentType", om.valueToTree((Object)this.getContentType()));
                    }
                    if (this.getSplitType() != null) {
                        obj.set("splitType", om.valueToTree((Object)this.getSplitType()));
                    }
                    return obj;
                }
            };
        }
    }
}

