/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.stepfunctions.tasks.TaskEnvironmentVariable;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ContainerOverride
extends JsiiSerializable {
    public String getContainerName();

    public List<String> getCommand();

    public Number getCpu();

    public List<TaskEnvironmentVariable> getEnvironment();

    public Number getMemoryLimit();

    public Number getMemoryReservation();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _containerName;
        @Nullable
        private List<String> _command;
        @Nullable
        private Number _cpu;
        @Nullable
        private List<TaskEnvironmentVariable> _environment;
        @Nullable
        private Number _memoryLimit;
        @Nullable
        private Number _memoryReservation;

        public Builder withContainerName(String value) {
            this._containerName = Objects.requireNonNull(value, "containerName is required");
            return this;
        }

        public Builder withCommand(@Nullable List<String> value) {
            this._command = value;
            return this;
        }

        public Builder withCpu(@Nullable Number value) {
            this._cpu = value;
            return this;
        }

        public Builder withEnvironment(@Nullable List<TaskEnvironmentVariable> value) {
            this._environment = value;
            return this;
        }

        public Builder withMemoryLimit(@Nullable Number value) {
            this._memoryLimit = value;
            return this;
        }

        public Builder withMemoryReservation(@Nullable Number value) {
            this._memoryReservation = value;
            return this;
        }

        public ContainerOverride build() {
            return new ContainerOverride(){
                private final String $containerName;
                @Nullable
                private final List<String> $command;
                @Nullable
                private final Number $cpu;
                @Nullable
                private final List<TaskEnvironmentVariable> $environment;
                @Nullable
                private final Number $memoryLimit;
                @Nullable
                private final Number $memoryReservation;
                {
                    this.$containerName = Objects.requireNonNull(_containerName, "containerName is required");
                    this.$command = _command;
                    this.$cpu = _cpu;
                    this.$environment = _environment;
                    this.$memoryLimit = _memoryLimit;
                    this.$memoryReservation = _memoryReservation;
                }

                @Override
                public String getContainerName() {
                    return this.$containerName;
                }

                @Override
                public List<String> getCommand() {
                    return this.$command;
                }

                @Override
                public Number getCpu() {
                    return this.$cpu;
                }

                @Override
                public List<TaskEnvironmentVariable> getEnvironment() {
                    return this.$environment;
                }

                @Override
                public Number getMemoryLimit() {
                    return this.$memoryLimit;
                }

                @Override
                public Number getMemoryReservation() {
                    return this.$memoryReservation;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("containerName", om.valueToTree((Object)this.getContainerName()));
                    if (this.getCommand() != null) {
                        obj.set("command", om.valueToTree(this.getCommand()));
                    }
                    if (this.getCpu() != null) {
                        obj.set("cpu", om.valueToTree((Object)this.getCpu()));
                    }
                    if (this.getEnvironment() != null) {
                        obj.set("environment", om.valueToTree(this.getEnvironment()));
                    }
                    if (this.getMemoryLimit() != null) {
                        obj.set("memoryLimit", om.valueToTree((Object)this.getMemoryLimit()));
                    }
                    if (this.getMemoryReservation() != null) {
                        obj.set("memoryReservation", om.valueToTree((Object)this.getMemoryReservation()));
                    }
                    return obj;
                }
            };
        }
    }
}

